package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Invoice implements Serializable {

    @JsonProperty("creationDateTime")
    private String creationDateTime;

    @JsonProperty("documentStatusCode")
    private String documentStatusCode;

    @JsonProperty("documentActionCode")
    private String documentActionCode;

    @JsonProperty("invoiceIdentification")
    private InvoiceIdentification invoiceIdentification;

    @JsonProperty("invoiceCurrencyCode")
    private String invoiceCurrencyCode;

    @JsonProperty("invoiceType")
    private String invoiceType;

    @JsonProperty("buyer")
    private Buyer buyer;

    @JsonProperty("seller")
    private Seller seller;

    @JsonProperty("taxCurrencyInformation")
    private List<TaxCurrencyInformation> taxCurrencyInformation;

    @JsonProperty("invoiceLineItem")
    private List<InvoiceLineItem> invoiceLineItem;

    public String getCreationDateTime() {
        return creationDateTime;
    }

    public void setCreationDateTime(String creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public String getDocumentStatusCode() {
        return documentStatusCode;
    }

    public void setDocumentStatusCode(String documentStatusCode) {
        this.documentStatusCode = documentStatusCode;
    }

    public String getDocumentActionCode() {
        return documentActionCode;
    }

    public void setDocumentActionCode(String documentActionCode) {
        this.documentActionCode = documentActionCode;
    }

    public InvoiceIdentification getInvoiceIdentification() {
        return invoiceIdentification;
    }

    public void setInvoiceIdentification(InvoiceIdentification invoiceIdentification) {
        this.invoiceIdentification = invoiceIdentification;
    }

    public String getInvoiceCurrencyCode() {
        return invoiceCurrencyCode;
    }

    public void setInvoiceCurrencyCode(String invoiceCurrencyCode) {
        this.invoiceCurrencyCode = invoiceCurrencyCode;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public Buyer getBuyer() {
        return buyer;
    }

    public void setBuyer(Buyer buyer) {
        this.buyer = buyer;
    }

    public Seller getSeller() {
        return seller;
    }

    public void setSeller(Seller seller) {
        this.seller = seller;
    }

    public List<TaxCurrencyInformation> getTaxCurrencyInformation() {
        return taxCurrencyInformation;
    }

    public void setTaxCurrencyInformation(List<TaxCurrencyInformation> taxCurrencyInformation) {
        this.taxCurrencyInformation = taxCurrencyInformation;
    }

    public List<InvoiceLineItem> getInvoiceLineItem() {
        return invoiceLineItem;
    }

    public void setInvoiceLineItem(List<InvoiceLineItem> invoiceLineItem) {
        this.invoiceLineItem = invoiceLineItem;
    }

    @Override
    public String toString() {
        return "Invoice [" +
                ((creationDateTime != null) ? "creationDateTime='" + creationDateTime + "', " : "") +
                ((documentStatusCode != null) ? "documentStatusCode='" + documentStatusCode + "', " : "") +
                ((documentActionCode != null) ? "documentActionCode='" + documentActionCode + "', " : "") +
                ((invoiceIdentification != null) ? "invoiceIdentification=" + invoiceIdentification + ", " : "") +
                ((invoiceCurrencyCode != null) ? "invoiceCurrencyCode='" + invoiceCurrencyCode + "', " : "") +
                ((invoiceType != null) ? "invoiceType='" + invoiceType + "', " : "") +
                ((buyer != null) ? "buyer=" + buyer + ", " : "") +
                ((seller != null) ? "seller=" + seller + ", " : "") +
                ((taxCurrencyInformation != null) ? "taxCurrencyInformation=" + Arrays.toString(taxCurrencyInformation.toArray()) + ", " : "") +
                ((invoiceLineItem != null) ? "invoiceLineItem=" + Arrays.toString(invoiceLineItem.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Invoice invoice = (Invoice) o;
        return Objects.equals(creationDateTime, invoice.creationDateTime) && Objects.equals(documentStatusCode, invoice.documentStatusCode) && Objects.equals(documentActionCode, invoice.documentActionCode) && Objects.equals(invoiceIdentification, invoice.invoiceIdentification) && Objects.equals(invoiceCurrencyCode, invoice.invoiceCurrencyCode) && Objects.equals(invoiceType, invoice.invoiceType) && Objects.equals(buyer, invoice.buyer) && Objects.equals(seller, invoice.seller) && Objects.equals(taxCurrencyInformation, invoice.taxCurrencyInformation) && Objects.equals(invoiceLineItem, invoice.invoiceLineItem);
    }

    @Override
    public int hashCode() {
        return Objects.hash(creationDateTime, documentStatusCode, documentActionCode, invoiceIdentification, invoiceCurrencyCode, invoiceType, buyer, seller, taxCurrencyInformation, invoiceLineItem);
    }
}