package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class InvoiceMessage implements Serializable {

    @JsonProperty("StandardBusinessDocumentHeader")
    private StandardBusinessDocumentHeader standardBusinessDocumentHeader;

    @JsonProperty("Invoice")
    private Invoice invoice;

    public StandardBusinessDocumentHeader getStandardBusinessDocumentHeader() {
        return standardBusinessDocumentHeader;
    }

    public void setStandardBusinessDocumentHeader(StandardBusinessDocumentHeader standardBusinessDocumentHeader) {
        this.standardBusinessDocumentHeader = standardBusinessDocumentHeader;
    }

    public Invoice getInvoice() {
        return invoice;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    @Override
    public String toString() {
        return "InvoiceMessage [" +
                ((standardBusinessDocumentHeader != null) ? "standardBusinessDocumentHeader=" + standardBusinessDocumentHeader + ", " : "") +
                ((invoice != null) ? "invoice=" + invoice + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InvoiceMessage that = (InvoiceMessage) o;
        return Objects.equals(standardBusinessDocumentHeader, that.standardBusinessDocumentHeader) && Objects.equals(invoice, that.invoice);
    }

    @Override
    public int hashCode() {
        return Objects.hash(standardBusinessDocumentHeader, invoice);
    }
}