package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class InvoiceLineItem implements Serializable {

    @JsonProperty("lineItemNumber")
    private String lineItemNumber;

    @JsonProperty("amountExclusiveAllowancesCharges")
    private AmountExclusiveAllowancesCharges amountExclusiveAllowancesCharges;

    @JsonProperty("referenceAmount")
    private String referenceAmount;

    public String getLineItemNumber() {
        return lineItemNumber;
    }

    public void setLineItemNumber(String lineItemNumber) {
        this.lineItemNumber = lineItemNumber;
    }

    public AmountExclusiveAllowancesCharges getAmountExclusiveAllowancesCharges() {
        return amountExclusiveAllowancesCharges;
    }

    public void setAmountExclusiveAllowancesCharges(AmountExclusiveAllowancesCharges amountExclusiveAllowancesCharges) {
        this.amountExclusiveAllowancesCharges = amountExclusiveAllowancesCharges;
    }

    public String getReferenceAmount() {
        return referenceAmount;
    }

    public void setReferenceAmount(String referenceAmount) {
        this.referenceAmount = referenceAmount;
    }

    @Override
    public String toString() {
        return "InvoiceLineItem [" +
                ((lineItemNumber != null) ? "lineItemNumber='" + lineItemNumber + "', " : "") +
                ((amountExclusiveAllowancesCharges != null) ? "amountExclusiveAllowancesCharges=" + amountExclusiveAllowancesCharges + ", " : "") +
                ((referenceAmount != null) ? "referenceAmount='" + referenceAmount + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InvoiceLineItem that = (InvoiceLineItem) o;
        return Objects.equals(lineItemNumber, that.lineItemNumber) && Objects.equals(amountExclusiveAllowancesCharges, that.amountExclusiveAllowancesCharges) && Objects.equals(referenceAmount, that.referenceAmount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(lineItemNumber, amountExclusiveAllowancesCharges, referenceAmount);
    }
}