package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SettlementLineItem implements Serializable {

    @JsonProperty("lineItemNumber")
    private String lineItemNumber;

    @JsonProperty("amountPaid")
    private AmountPaid amountPaid;

    @JsonProperty("invoice")
    private List<Invoice> invoice;

    @JsonProperty("settlementParty")
    private List<SettlementParty> settlementParty;

    private String documentPayItem;
    private String customerReference;
    private String chargebackCustomerReference;
    private String reasonCode;
    private OriginalAmount originalAmount;

    public String getLineItemNumber() {
        return lineItemNumber;
    }

    public void setLineItemNumber(String lineItemNumber) {
        this.lineItemNumber = lineItemNumber;
    }

    public AmountPaid getAmountPaid() {
        return amountPaid;
    }

    public void setAmountPaid(AmountPaid amountPaid) {
        this.amountPaid = amountPaid;
    }

    public OriginalAmount getOriginalAmount() {
        return originalAmount;
    }

    public void setOriginalAmount(OriginalAmount originalAmount) {
        this.originalAmount = originalAmount;
    }

    public List<Invoice> getInvoice() {
        return invoice;
    }

    public void setInvoice(List<Invoice> invoice) {
        this.invoice = invoice;
    }

    public List<SettlementParty> getSettlementParty() {
        return settlementParty;
    }

    public void setSettlementParty(List<SettlementParty> settlementParty) {
        this.settlementParty = settlementParty;
    }

    public String getCustomerReference() {
        return customerReference;
    }

    public void setCustomerReference(String customerReference) {
        this.customerReference = customerReference;
    }

    public String getChargebackCustomerReference() {
        return chargebackCustomerReference;
    }

    public void setChargebackCustomerReference(String chargebackCustomerReference) {
        this.chargebackCustomerReference = chargebackCustomerReference;
    }

    public String getReasonCode() {
        return reasonCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    public String getDocumentPayItem() {
        return documentPayItem;
    }

    public void setDocumentPayItem(String documentPayItem) {
        this.documentPayItem = documentPayItem;
    }

    @Override
    public String toString() {
        return "SettlementLineItem [" +
                ((lineItemNumber != null) ? "lineItemNumber='" + lineItemNumber + "', " : "") +
                ((amountPaid != null) ? "amountPaid=" + amountPaid + ", " : "") +
                ((originalAmount != null) ? "originalAmount='" + originalAmount + "', " : "") +
                ((invoice != null) ? "invoice=" + Arrays.toString(invoice.toArray()) + ", " : "") +
                ((settlementParty != null) ? "settlementParty=" + Arrays.toString(settlementParty.toArray()) + ", " : "") +
                ((documentPayItem != null) ? "documentPayItem='" + documentPayItem + "', " : "") +
                ((customerReference != null) ? "customerReference='" + customerReference + "', " : "") +
                ((chargebackCustomerReference != null) ? "chargebackCustomerReference='" + chargebackCustomerReference + "', " : "") +
                ((reasonCode != null) ? "reasonCode='" + reasonCode + "', " : "") +
                ((originalAmount != null) ? "originalAmount=" + originalAmount + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SettlementLineItem that = (SettlementLineItem) o;
        return Objects.equals(lineItemNumber, that.lineItemNumber) && Objects.equals(amountPaid, that.amountPaid) && Objects.equals(originalAmount, that.originalAmount) && Objects.equals(invoice, that.invoice) && Objects.equals(settlementParty, that.settlementParty) && Objects.equals(documentPayItem, that.documentPayItem) && Objects.equals(customerReference, that.customerReference) && Objects.equals(chargebackCustomerReference, that.chargebackCustomerReference) && Objects.equals(reasonCode, that.reasonCode) && Objects.equals(originalAmount, that.originalAmount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(lineItemNumber, amountPaid, originalAmount, invoice, settlementParty, documentPayItem, customerReference, chargebackCustomerReference, reasonCode, originalAmount);
    }
}