package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Transaction implements Serializable {

    @JsonProperty("transactionIdentification")
    private TransactionIdentification transactionIdentification;

    @JsonProperty("documentCommand")
    private DocumentCommand documentCommand;

    public TransactionIdentification getTransactionIdentification() {
        return transactionIdentification;
    }

    public void setTransactionIdentification(TransactionIdentification transactionIdentification) {
        this.transactionIdentification = transactionIdentification;
    }

    public DocumentCommand getDocumentCommand() {
        return documentCommand;
    }

    public void setDocumentCommand(DocumentCommand documentCommand) {
        this.documentCommand = documentCommand;
    }

    @Override
    public String toString() {
        return "Transaction [" +
                ((transactionIdentification != null) ? "transactionIdentification=" + transactionIdentification + ", " : "") +
                ((documentCommand != null) ? "documentCommand=" + documentCommand + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Transaction that = (Transaction) o;
        return Objects.equals(transactionIdentification, that.transactionIdentification) && Objects.equals(documentCommand, that.documentCommand);
    }

    @Override
    public int hashCode() {
        return Objects.hash(transactionIdentification, documentCommand);
    }
}