package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class AdditionalPartyIdentification implements Serializable {

    @JsonProperty("@additionalPartyIdentificationTypeCode")
    private String typeCode;

    @JsonProperty("#text")
    private String text;

    // Me hago un par de constructores comodos, ya que se usa en muchos lados

    public AdditionalPartyIdentification() {
    }

    public AdditionalPartyIdentification(String typeCode, String text) {
        this.typeCode = typeCode;
        this.text = text;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String toString() {
        return "AdditionalPartyIdentification [" +
                ((typeCode != null) ? "additionalPartyIdentificationTypeCode='" + typeCode + "', " : "") +
                ((text != null) ? "text='" + text + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AdditionalPartyIdentification that = (AdditionalPartyIdentification) o;
        return Objects.equals(typeCode, that.typeCode) && Objects.equals(text, that.text);
    }

    @Override
    public int hashCode() {
        return Objects.hash(typeCode, text);
    }
}