package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class AmountWithCurrency implements Serializable {

    @JsonProperty("@currencyCode")
    private String currency;

    @JsonProperty("#text")
    private String amount;

    // Me hago un par de constructores comodos, ya que se usa en muchos lados

    public AmountWithCurrency() {
    }

    public AmountWithCurrency(String amount, String currency) {
        this.amount = amount;
        this.currency = currency;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    @Override
    public String toString() {
        return "AmountWithCurrency [" +
                ((currency != null) ? "currencyCode='" + currency + "', " : "") +
                ((amount != null) ? "text='" + amount + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AmountWithCurrency that = (AmountWithCurrency) o;
        return Objects.equals(currency, that.currency) && Objects.equals(amount, that.amount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(currency, amount);
    }
}