package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryOrTransportTerms implements Serializable {

    @JsonProperty("freightHandlingCode")
    private String freightHandlingCode;

    public String getFreightHandlingCode() {
        return freightHandlingCode;
    }

    public void setFreightHandlingCode(String freightHandlingCode) {
        this.freightHandlingCode = freightHandlingCode;
    }

    @Override
    public String toString() {
        return "DeliveryOrTransportTerms [" +
                ((freightHandlingCode != null) ? "freightHandlingCode='" + freightHandlingCode + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DeliveryOrTransportTerms that = (DeliveryOrTransportTerms) o;
        return Objects.equals(freightHandlingCode, that.freightHandlingCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(freightHandlingCode);
    }
}