package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class DocumentCommand implements Serializable {

    @JsonProperty("documentCommandHeader")
    private DocumentCommandHeader documentCommandHeader;

    @JsonProperty("document")
    private Document document;

    public DocumentCommandHeader getDocumentCommandHeader() {
        return documentCommandHeader;
    }

    public void setDocumentCommandHeader(DocumentCommandHeader documentCommandHeader) {
        this.documentCommandHeader = documentCommandHeader;
    }

    public Document getDocument() {
        return document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    @Override
    public String toString() {
        return "DocumentCommand [" +
                ((documentCommandHeader != null) ? "documentCommandHeader=" + documentCommandHeader + ", " : "") +
                ((document != null) ? "document=" + document + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DocumentCommand that = (DocumentCommand) o;
        return Objects.equals(documentCommandHeader, that.documentCommandHeader) && Objects.equals(document, that.document);
    }

    @Override
    public int hashCode() {
        return Objects.hash(documentCommandHeader, document);
    }
}