package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class DocumentCommandHeader implements Serializable {

    @JsonProperty("documentCommandIdentification")
    private Identification documentCommandIdentification;

    public Identification getDocumentCommandIdentification() {
        return documentCommandIdentification;
    }

    public void setDocumentCommandIdentification(Identification documentCommandIdentification) {
        this.documentCommandIdentification = documentCommandIdentification;
    }

    @Override
    public String toString() {
        return "DocumentCommandHeader [" +
                ((documentCommandIdentification != null) ? "documentCommandIdentification=" + documentCommandIdentification + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DocumentCommandHeader that = (DocumentCommandHeader) o;
        return Objects.equals(documentCommandIdentification, that.documentCommandIdentification);
    }

    @Override
    public int hashCode() {
        return Objects.hash(documentCommandIdentification);
    }
}