package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SettlementMessage implements Serializable {

    @JsonProperty("StandardBusinessDocumentHeader")
    private StandardBusinessDocumentHeader standardBusinessDocumentHeader;

    @JsonProperty("settlement")
    private Settlement settlement;

    public StandardBusinessDocumentHeader getStandardBusinessDocumentHeader() {
        return standardBusinessDocumentHeader;
    }

    public void setStandardBusinessDocumentHeader(StandardBusinessDocumentHeader standardBusinessDocumentHeader) {
        this.standardBusinessDocumentHeader = standardBusinessDocumentHeader;
    }

    public Settlement getSettlement() {
        return settlement;
    }

    public void setSettlement(Settlement settlement) {
        this.settlement = settlement;
    }

    @Override
    public String toString() {
        return "SettlementMessage [" +
                ((standardBusinessDocumentHeader != null) ? "standardBusinessDocumentHeader=" + standardBusinessDocumentHeader + ", " : "") +
                ((settlement != null) ? "settlement=" + settlement + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SettlementMessage that = (SettlementMessage) o;
        return Objects.equals(standardBusinessDocumentHeader, that.standardBusinessDocumentHeader) && Objects.equals(settlement, that.settlement);
    }

    @Override
    public int hashCode() {
        return Objects.hash(standardBusinessDocumentHeader, settlement);
    }
}