package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Extension implements Serializable {

    @JsonProperty("reference")
    private String reference;

    @JsonProperty("party")
    private Party party;

    @JsonProperty("remitTo")
    private PartyInRole remitTo;

    // Me hago un par de constructores comodos, ya que se usa en muchos lados

    public Extension() {
    }

    public Extension(String reference) {
        this(reference, null);
    }

    public Extension(Party party) {
        this(null, party);
    }

    public Extension(String reference, Party party) {
        this.reference = reference;
        this.party = party;
    }

    public String getReference() {
        return reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Party getParty() {
        return party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public PartyInRole getRemitTo() {
        return remitTo;
    }

    public void setRemitTo(PartyInRole remitTo) {
        this.remitTo = remitTo;
    }

    @Override
    public String toString() {
        return "Extension ["
                + ((reference != null) ? "reference=" + reference + ", " : "")
                + ((party != null) ? "party=" + party + ", " : "")
                + ((remitTo != null) ? "remitTo=" + remitTo : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Extension extension = (Extension) o;
        return Objects.equals(reference, extension.reference) && Objects.equals(party, extension.party) && Objects.equals(remitTo, extension.remitTo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(reference, party, remitTo);
    }
}