package ar.com.sdd.praapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ServiceTransaction implements Serializable {

    @JsonProperty("@TypeOfServiceTransaction")
    private String typeOfServiceTransaction;

    public String getTypeOfServiceTransaction() {
        return typeOfServiceTransaction;
    }

    public void setTypeOfServiceTransaction(String typeOfServiceTransaction) {
        this.typeOfServiceTransaction = typeOfServiceTransaction;
    }

    @Override
    public String toString() {
        return "ServiceTransaction [" +
                ((typeOfServiceTransaction != null) ? "typeOfServiceTransaction='" + typeOfServiceTransaction + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ServiceTransaction that = (ServiceTransaction) o;
        return Objects.equals(typeOfServiceTransaction, that.typeOfServiceTransaction);
    }

    @Override
    public int hashCode() {
        return Objects.hash(typeOfServiceTransaction);
    }
}