/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.prowidesoftware.swift.model.BbanEntryType;
import com.prowidesoftware.swift.model.BbanEntryTypeDeserializer;
import com.prowidesoftware.swift.model.BbanStructureDTO;
import com.prowidesoftware.swift.utils.Lib;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class BbanStructureValidations {
    private static final transient Logger log = Logger.getLogger(BbanStructureValidations.class.getName());
    private static BbanStructureValidations instance = null;
    private static final Type REVIEW_TYPE = new TypeToken<List<BbanStructureDTO>>(){}.getType();
    private static String JSON_FILE = "BbanStructureValidations.json";
    private List<BbanStructureDTO> bbanStructures = null;

    private BbanStructureValidations() {
        Gson gson = new GsonBuilder().registerTypeAdapter(BbanEntryType.class, (Object)new BbanEntryTypeDeserializer()).create();
        String reader = null;
        try {
            reader = Lib.readResource(JSON_FILE, null);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Cannot load " + JSON_FILE + " from classpath, the BBAN structure validations will be initialized empty", e);
        }
        if (reader != null) {
            this.bbanStructures = (List)gson.fromJson(reader, REVIEW_TYPE);
        }
    }

    public static BbanStructureValidations getInstance() {
        if (instance == null) {
            instance = new BbanStructureValidations();
        }
        return instance;
    }

    public List<BbanStructureDTO> getBbanStructures() {
        return this.bbanStructures;
    }

    public void setBbanStructures(List<BbanStructureDTO> bbanStructures) {
        this.bbanStructures = bbanStructures;
    }

    public BbanStructureDTO forCountry(String countryCode) {
        BbanStructureDTO bbanStructure = null;
        if (this.bbanStructures != null) {
            for (BbanStructureDTO structure : this.bbanStructures) {
                if (!StringUtils.equals((CharSequence)structure.getCountry_coode(), (CharSequence)countryCode)) continue;
                bbanStructure = structure;
                break;
            }
        }
        return bbanStructure;
    }

    public boolean contains(String countryCode) {
        return this.supportedCountries().contains(countryCode);
    }

    public List<String> supportedCountries() {
        ArrayList<String> countryCodes = new ArrayList<String>(this.bbanStructures.size());
        for (BbanStructureDTO structure : this.bbanStructures) {
            countryCodes.add(structure.getCountry_coode());
        }
        return Collections.unmodifiableList(countryCodes);
    }

    public BbanStructureValidations add(BbanStructureDTO bbanStructure) {
        if (this.bbanStructures == null) {
            this.bbanStructures = new ArrayList<BbanStructureDTO>();
        }
        if (this.contains(bbanStructure.getCountry_coode())) {
            log.warning("Duplicate BBAN configuration for country " + bbanStructure.getCountry_coode());
        }
        this.bbanStructures.add(bbanStructure);
        return this;
    }
}

