/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field34C
extends Field
implements Serializable,
CurrencyContainer,
AmountContainer {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "34C";
    public static final String F_34C = "34C";
    public static final String PARSER_PATTERN = "S/[c]<CUR>N";
    public static final String COMPONENTS_PATTERN = "SSCN";
    public static final Integer COMMISSION_TYPE = 1;
    public static final Integer SIGN = 2;
    public static final Integer CURRENCY = 3;
    public static final Integer AMOUNT = 4;

    public Field34C() {
        super(4);
    }

    public Field34C(String value) {
        super(value);
    }

    public Field34C(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"34C")) {
            throw new IllegalArgumentException("cannot create field 34C from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        String toparse = SwiftParseUtils.getTokenSecond(value, "/");
        String prefix = SwiftParseUtils.getAlphaPrefix(toparse);
        if (prefix != null) {
            if (prefix.length() > 3) {
                this.setComponent2(StringUtils.substring((String)prefix, (int)0, (int)1));
                this.setComponent3(StringUtils.substring((String)prefix, (int)1, (int)prefix.length()));
            } else {
                this.setComponent3(prefix);
            }
        }
        this.setComponent4(SwiftParseUtils.getNumericSuffix(value));
    }

    public static Field34C newInstance(Field34C source) {
        Field34C cp = new Field34C();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        this.append(result, 3);
        this.append(result, 4);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("34C", value);
    }

    public static Tag emptyTag() {
        return new Tag("34C", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getCommissionType() {
        return this.getComponent(1);
    }

    public Field34C setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field34C setCommissionType(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent2AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(2);
    }

    public String getSign() {
        return this.getComponent(2);
    }

    public Field34C setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field34C setSign(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Currency getComponent3AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public String getCurrency() {
        return this.getComponent(3);
    }

    public Currency getCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public Field34C setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field34C setComponent3(Currency component3) {
        this.setComponent(3, SwiftFormatUtils.getCurrency(component3));
        return this;
    }

    public Field34C setCurrency(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field34C setCurrency(Currency component3) {
        this.setComponent3(component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getAmount() {
        return this.getComponent(4);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public Field34C setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field34C setComponent4(Number component4) {
        this.setComponent(4, SwiftFormatUtils.getNumber(component4));
        return this;
    }

    public Field34C setAmount(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field34C setAmount(Number component4) {
        this.setComponent4(component4);
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        return CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
    }

    @Override
    public List<Currency> currencies() {
        List<String> l = this.currencyStrings();
        if (l.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> result = new ArrayList<Currency>();
        for (String s : l) {
            result.add(Currency.getInstance(s));
        }
        return result;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "34C";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "4!c/[<N>]<CUR><AMOUNT>15";
    }

    public static Field34C get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("34C");
        if (t == null) {
            return null;
        }
        return new Field34C(t);
    }

    public static Field34C get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field34C.get(msg.getBlock4());
    }

    public static List<Field34C> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field34C.getAll(msg.getBlock4());
    }

    public static List<Field34C> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("34C");
        if (arr != null && arr.length > 0) {
            ArrayList<Field34C> result = new ArrayList<Field34C>(arr.length);
            for (Tag f : arr) {
                result.add(new Field34C(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 34C");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            Number n = this.getComponent4AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Commission Type");
        result.add("Sign");
        result.add("Currency");
        result.add("Amount");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "commissionType");
        result.put(2, "sign");
        result.put(3, "currency");
        result.put(4, "amount");
        return result;
    }

    public static Field34C fromJson(String json) {
        Field34C field = new Field34C();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("commissionType") != null) {
            field.setComponent1(jsonObject.get("commissionType").getAsString());
        }
        if (jsonObject.get("sign") != null) {
            field.setComponent2(jsonObject.get("sign").getAsString());
        }
        if (jsonObject.get("currency") != null) {
            field.setComponent3(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent4(jsonObject.get("amount").getAsString());
        }
        return field;
    }
}

