/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.io.parser.MxParser;
import com.prowidesoftware.swift.model.AbstractSwiftMessage;
import com.prowidesoftware.swift.model.FileFormat;
import com.prowidesoftware.swift.model.MxBusinessProcess;
import com.prowidesoftware.swift.model.MxId;
import com.prowidesoftware.swift.model.MxNode;
import com.prowidesoftware.swift.model.mx.AbstractMX;
import com.prowidesoftware.swift.model.mx.BusinessHeader;
import com.prowidesoftware.swift.model.mx.dic.ApplicationHeader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

@Entity(name="mx")
@DiscriminatorValue(value="mx")
public class MxSwiftMessage
extends AbstractSwiftMessage {
    private static final long serialVersionUID = -4394356007627575831L;
    private static final transient Logger log = Logger.getLogger(MxSwiftMessage.class.getName());
    @Enumerated(value=EnumType.STRING)
    @Column(length=4, name="business_process")
    private MxBusinessProcess businessProcess;
    @Column(length=3)
    private String functionality;
    @Column(length=3)
    private String variant;
    @Column(length=2)
    private String version;

    public MxSwiftMessage() {
    }

    public MxSwiftMessage(String xml) {
        super(xml);
    }

    public static MxSwiftMessage parse(String xml) {
        return new MxSwiftMessage(xml);
    }

    public MxSwiftMessage(InputStream stream) throws IOException {
        super(stream);
    }

    public static MxSwiftMessage parse(InputStream stream) throws IOException {
        return new MxSwiftMessage(stream);
    }

    public MxSwiftMessage(File file) throws IOException {
        super(file);
    }

    public static MxSwiftMessage parse(File file) throws IOException {
        return new MxSwiftMessage(file);
    }

    public MxSwiftMessage(AbstractMX mx) {
        super(mx.message("message"));
    }

    @Override
    protected void updateFromMessage() {
        this._updateFromMessage(null);
    }

    private void _updateFromMessage(MxId id) {
        if (this.message() != null && this.message().length() > 0) {
            MxParser parser = new MxParser(this.message());
            BusinessHeader h = parser.parseBusinessHeader();
            if (!this._update(h)) {
                this._update(parser.parse());
            }
            if (id != null) {
                this._update(id);
            } else {
                this._update(parser.detectMessage());
            }
        }
    }

    public void updateFromXML(String xml) {
        this.updateFromXML(xml, null);
    }

    public void updateFromXML(String xml, MxId id) {
        Validate.notNull((Object)xml, (String)"the xml message parameter cannot be null", (Object[])new Object[0]);
        this.setMessage(xml);
        this.setFileFormat(FileFormat.MX);
        this._updateFromMessage(id);
    }

    public void updateFromModel(AbstractMX mx) {
        Validate.notNull((Object)mx, (String)"the mx parameter cannot be null", (Object[])new Object[0]);
        this.setMessage(mx.message("message", true));
        this.setFileFormat(FileFormat.MX);
        if (!this._update(mx.getBusinessHeader())) {
            MxParser parser = new MxParser(this.message());
            this._update(parser.parse());
        }
        this._update(mx.getMxId());
    }

    private boolean _update(MxId id) {
        if (id != null) {
            this.identifier = id.id();
            this.businessProcess = id.getBusinessProcess();
            this.functionality = id.getFunctionality();
            this.variant = id.getVariant();
            this.version = id.getVersion();
            return true;
        }
        return false;
    }

    private boolean _update(BusinessHeader h) {
        boolean updated = false;
        if (h != null) {
            String reference;
            String to;
            String from = h.from();
            if (from != null) {
                this.sender = this.bic11(from);
                updated = true;
            }
            if ((to = h.to()) != null) {
                this.receiver = this.bic11(to);
                updated = true;
            }
            if ((reference = h.reference()) != null) {
                this.setReference(h.reference());
                updated = true;
            }
        }
        return updated;
    }

    private boolean _update(MxNode n) {
        MxNode groupHeader;
        boolean updated = false;
        MxNode mxNode = groupHeader = n != null ? n.findFirstByName("GrpHdr") : null;
        if (groupHeader != null) {
            MxNode reference;
            MxNode receiverBic;
            MxNode senderBic = groupHeader.findFirst("./InstgAgt/FinInstnId/BIC");
            if (senderBic != null) {
                this.sender = this.bic11(senderBic.getValue());
                updated = true;
            }
            if ((receiverBic = groupHeader.findFirst("./InstdAgt/FinInstnId/BIC")) != null) {
                this.receiver = this.bic11(receiverBic.getValue());
                updated = true;
            }
            if ((reference = groupHeader.findFirst("./MsgId")) != null) {
                this.setReference(reference.getValue());
                updated = true;
            }
        }
        return updated;
    }

    public MxBusinessProcess getBusinessProcess() {
        return this.businessProcess;
    }

    public void setBusinessProcess(MxBusinessProcess businessProcess) {
        this.businessProcess = businessProcess;
    }

    public String getFunctionality() {
        return this.functionality;
    }

    public void setFunctionality(String functionality) {
        this.functionality = functionality;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MxSwiftMessage that = (MxSwiftMessage)o;
        return this.businessProcess == that.businessProcess && Objects.equals(this.functionality, that.functionality) && Objects.equals(this.variant, that.variant) && Objects.equals(this.version, that.version);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.businessProcess, this.functionality, this.variant, this.version});
    }

    @Deprecated
    protected void setDataFromNamespace(String namespace) {
        MxBusinessProcess bpEnum;
        DeprecationUtils.phase3(this.getClass(), "setDataFromNamespace(String)", "The internal metadata is set automatically from the message content when the object is constructed from String, File or Stream.");
        Validate.notNull((Object)namespace, (String)"namespace can not be null", (Object[])new Object[0]);
        String[] tokens = StringUtils.split((String)namespace, (char)'.');
        if (tokens == null || tokens.length < 4) {
            throw new IllegalArgumentException("Expected at least 4 tokens in namespace '" + namespace + "'");
        }
        String bp = tokens[tokens.length - 4];
        String func = tokens[tokens.length - 3];
        String var = tokens[tokens.length - 2];
        String ver = tokens[tokens.length - 1];
        try {
            bpEnum = MxBusinessProcess.valueOf(bp);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown business process '" + bp + "'", e);
        }
        this.setBusinessProcess(bpEnum);
        this.setFunctionality(func);
        this.setVariant(var);
        this.setVersion(ver);
    }

    public BusinessHeader getBusinessHeader() {
        MxParser parser = new MxParser(this.message());
        return parser.parseBusinessHeader();
    }

    @Deprecated
    public ApplicationHeader getApplicationHeader() {
        MxParser parser = new MxParser(this.message());
        BusinessHeader h = parser.parseBusinessHeader();
        if (h != null && h.getApplicationHeader() != null) {
            return h.getApplicationHeader();
        }
        return null;
    }

    @Deprecated
    public void setApplicationHeader(ApplicationHeader applicationHeader) {
        log.warning("Obsolete API call. The application header is no longer stored as class attribute in " + this.getClass().getName());
    }

    public void copyTo(MxSwiftMessage msg) {
        super.copyTo(msg);
        msg.setBusinessProcess(this.getBusinessProcess());
        msg.setFunctionality(this.getFunctionality());
        msg.setVariant(this.getVariant());
        msg.setVersion(this.getVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MxSwiftMessage id=").append(this.getId()).append(" message=").append(this.getMessage());
        return sb.toString();
    }

    public static MxSwiftMessage fromJson(String json) {
        Gson gson = new GsonBuilder().create();
        return (MxSwiftMessage)gson.fromJson(json, MxSwiftMessage.class);
    }

    public MxId getMxId() {
        return new MxId(this.businessProcess, this.functionality, this.variant, this.version);
    }
}

