/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field13K
extends Field
implements Serializable,
AmountContainer,
GenericField {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "13K";
    public static final String F_13K = "13K";
    public static final String PARSER_PATTERN = ":S//S/N";
    public static final String COMPONENTS_PATTERN = "SSN";
    public static final Integer QUALIFIER = 1;
    public static final Integer NUMBER_ID = 2;
    public static final Integer AMOUNT = 3;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field13K() {
        super(3);
    }

    public Field13K(String value) {
        super(value);
    }

    public Field13K(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"13K")) {
            throw new IllegalArgumentException("cannot create field 13K from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        this.setComponent2(SwiftParseUtils.getTokenFirst(toparse, "/"));
        this.setComponent3(SwiftParseUtils.getTokenSecondLast(toparse, "/"));
    }

    public static Field13K newInstance(Field13K source) {
        Field13K cp = new Field13K();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("13K", value);
    }

    public static Tag emptyTag() {
        return new Tag("13K", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field13K setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field13K setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent2AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(2);
    }

    public String getNumberId() {
        return this.getComponent(2);
    }

    public Field13K setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field13K setNumberId(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Number getComponent3AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public String getAmount() {
        return this.getComponent(3);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public Field13K setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field13K setComponent3(Number component3) {
        this.setComponent(3, SwiftFormatUtils.getNumber(component3));
        return this;
    }

    public Field13K setAmount(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field13K setAmount(Number component3) {
        this.setComponent3(component3);
        return this;
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "13K";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//3!c/<AMOUNT>15";
    }

    public static Field13K get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("13K");
        if (t == null) {
            return null;
        }
        return new Field13K(t);
    }

    public static Field13K get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field13K.get(msg.getBlock4());
    }

    public static List<Field13K> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field13K.getAll(msg.getBlock4());
    }

    public static List<Field13K> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("13K");
        if (arr != null && arr.length > 0) {
            ArrayList<Field13K> result = new ArrayList<Field13K>(arr.length);
            for (Tag f : arr) {
                result.add(new Field13K(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 13K");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            Number n = this.getComponent3AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Number Id");
        result.add("Amount");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "numberId");
        result.put(3, "amount");
        return result;
    }

    public static Field13K fromJson(String json) {
        Field13K field = new Field13K();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("numberId") != null) {
            field.setComponent2(jsonObject.get("numberId").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent3(jsonObject.get("amount").getAsString());
        }
        return field;
    }
}

