/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field22H
extends Field
implements Serializable,
GenericField {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "22H";
    public static final String F_22H = "22H";
    public static final String PARSER_PATTERN = ":S//S";
    public static final String COMPONENTS_PATTERN = "SS";
    public static final Integer QUALIFIER = 1;
    public static final Integer CODE = 2;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field22H() {
        super(2);
    }

    public Field22H(String value) {
        super(value);
    }

    public Field22H(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"22H")) {
            throw new IllegalArgumentException("cannot create field 22H from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "//"));
    }

    public static Field22H newInstance(Field22H source) {
        Field22H cp = new Field22H();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("22H", value);
    }

    public static Tag emptyTag() {
        return new Tag("22H", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field22H setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field22H setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent2AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(2);
    }

    public String getCode() {
        return this.getComponent(2);
    }

    public Field22H setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field22H setCode(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "22H";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//4!c";
    }

    public static Field22H get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("22H");
        if (t == null) {
            return null;
        }
        return new Field22H(t);
    }

    public static Field22H get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field22H.get(msg.getBlock4());
    }

    public static List<Field22H> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field22H.getAll(msg.getBlock4());
    }

    public static List<Field22H> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("22H");
        if (arr != null && arr.length > 0) {
            ArrayList<Field22H> result = new ArrayList<Field22H>(arr.length);
            for (Tag f : arr) {
                result.add(new Field22H(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 22H");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Code");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "code");
        return result;
    }

    public static Field22H fromJson(String json) {
        Field22H field = new Field22H();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("code") != null) {
            field.setComponent2(jsonObject.get("code").getAsString());
        }
        return field;
    }
}

