/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt8xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field16A;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field23;
import com.prowidesoftware.swift.model.field.Field26A;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field33B;
import com.prowidesoftware.swift.model.field.Field34B;
import com.prowidesoftware.swift.model.field.Field51A;
import com.prowidesoftware.swift.model.field.Field51C;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52D;
import com.prowidesoftware.swift.model.field.Field53A;
import com.prowidesoftware.swift.model.field.Field53B;
import com.prowidesoftware.swift.model.field.Field53D;
import com.prowidesoftware.swift.model.field.Field54A;
import com.prowidesoftware.swift.model.field.Field54B;
import com.prowidesoftware.swift.model.field.Field54D;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.field.Field73;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT800
extends AbstractMT
implements Serializable {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT800.class.getName());
    public static final String NAME = "800";

    public MT800(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT800(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT800 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT800(m);
    }

    public MT800() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT800(String sender, String receiver) {
        super(800, sender, receiver);
    }

    @Deprecated
    public MT800(int messageType, String sender, String receiver) {
        super(800, sender, receiver);
        DeprecationUtils.phase3(this.getClass(), "MT800(int, String, String)", "Use the constructor MT800(sender, receiver) instead.");
    }

    public MT800(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT800.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT800 object from FIN content with a Service Message. Check if the MT800 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT800 object from FIN content with message type " + param.getType());
        }
    }

    public static MT800 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT800(fin);
    }

    public MT800(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT800 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT800(stream);
    }

    public MT800(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT800 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT800(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT800 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT800 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT800 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT800 fromJson(String json) {
        return (MT800)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field51A getField51A() {
        Tag t = this.tag("51A");
        if (t != null) {
            return new Field51A(t.getValue());
        }
        return null;
    }

    public Field51C getField51C() {
        Tag t = this.tag("51C");
        if (t != null) {
            return new Field51C(t.getValue());
        }
        return null;
    }

    public Field34B getField34B() {
        Tag t = this.tag("34B");
        if (t != null) {
            return new Field34B(t.getValue());
        }
        return null;
    }

    public Field16A getField16A() {
        Tag t = this.tag("16A");
        if (t != null) {
            return new Field16A(t.getValue());
        }
        return null;
    }

    public Field32A getField32A() {
        Tag t = this.tag("32A");
        if (t != null) {
            return new Field32A(t.getValue());
        }
        return null;
    }

    public Field52A getField52A() {
        Tag t = this.tag("52A");
        if (t != null) {
            return new Field52A(t.getValue());
        }
        return null;
    }

    public Field52D getField52D() {
        Tag t = this.tag("52D");
        if (t != null) {
            return new Field52D(t.getValue());
        }
        return null;
    }

    public Field53A getField53A() {
        Tag t = this.tag("53A");
        if (t != null) {
            return new Field53A(t.getValue());
        }
        return null;
    }

    public Field53B getField53B() {
        Tag t = this.tag("53B");
        if (t != null) {
            return new Field53B(t.getValue());
        }
        return null;
    }

    public Field53D getField53D() {
        Tag t = this.tag("53D");
        if (t != null) {
            return new Field53D(t.getValue());
        }
        return null;
    }

    public Field54A getField54A() {
        Tag t = this.tag("54A");
        if (t != null) {
            return new Field54A(t.getValue());
        }
        return null;
    }

    public Field54B getField54B() {
        Tag t = this.tag("54B");
        if (t != null) {
            return new Field54B(t.getValue());
        }
        return null;
    }

    public Field54D getField54D() {
        Tag t = this.tag("54D");
        if (t != null) {
            return new Field54D(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }

    public List<Field23> getField23() {
        ArrayList<Field23> result = new ArrayList<Field23>();
        Tag[] tags = this.tags("23");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field23(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field30> getField30() {
        ArrayList<Field30> result = new ArrayList<Field30>();
        Tag[] tags = this.tags("30");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field30(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field26A> getField26A() {
        ArrayList<Field26A> result = new ArrayList<Field26A>();
        Tag[] tags = this.tags("26A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field26A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field33B> getField33B() {
        ArrayList<Field33B> result = new ArrayList<Field33B>();
        Tag[] tags = this.tags("33B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field33B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field73> getField73() {
        ArrayList<Field73> result = new ArrayList<Field73>();
        Tag[] tags = this.tags("73");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field73(tag.getValue()));
            }
        }
        return result;
    }

    public static List<SequenceA> getSequenceAList(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            ArrayList<SequenceA> result = new ArrayList<SequenceA>();
            List<SwiftTagListBlock> bs = parentSequence.getSubBlocksDelimitedWithOptionalTail(SequenceA.START, SequenceA.END, SequenceA.TAIL);
            if (bs != null && !bs.isEmpty()) {
                for (SwiftTagListBlock s : bs) {
                    result.add(new SequenceA(s));
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List<SequenceA> getSequenceAList() {
        return MT800.getSequenceAList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceB getSequenceB() {
        return this.getSequenceB(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceB getSequenceB(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            SwiftTagListBlock content = parentSequence.getSubBlockDelimitedWithOptionalTail(SequenceB.START, SequenceB.END, SequenceB.TAIL);
            if (log.isLoggable(Level.FINE)) {
                if (content == null) {
                    log.fine("content for sequence SequenceB: is null");
                } else {
                    log.fine("content for sequence SequenceB: " + content.tagNamesList());
                }
            }
            if (content == null) {
                return new SequenceB();
            }
            return new SequenceB(content);
        }
        return null;
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"34B"};
        protected static final String[] END = new String[]{"32A"};
        protected static final String[] TAIL = new String[]{"52A", "52D", "53A", "53B", "53D", "54A", "54B", "54D", "72"};

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB newInstance(Tag ... tags) {
            return SequenceB.newInstance(0, 0, tags);
        }

        public static SequenceB newInstance(int start, int end, Tag ... tags) {
            SequenceB result = new SequenceB();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"23"};
        protected static final String[] END = new String[]{"33B"};
        protected static final String[] TAIL = new String[]{"73"};

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            return SequenceA.newInstance(0, 0, tags);
        }

        public static SequenceA newInstance(int start, int end, Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }
}

