/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field30X
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "30X";
    public static final String F_30X = "30X";
    public static final String PARSER_PATTERN = "S";
    public static final String COMPONENTS_PATTERN = "D";
    public static final Integer DATE = 1;

    public Field30X() {
        super(1);
    }

    public Field30X(String value) {
        super(value);
    }

    public Field30X(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"30X")) {
            throw new IllegalArgumentException("cannot create field 30X from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(1);
        this.setComponent1(value);
    }

    public static Field30X newInstance(Field30X source) {
        Field30X cp = new Field30X();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("30X", value);
    }

    public static Tag emptyTag() {
        return new Tag("30X", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(1));
    }

    public String getDate() {
        return this.getComponent(1);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(1));
    }

    public Field30X setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field30X setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate4(component1));
        return this;
    }

    public Field30X setDate(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field30X setDate(Calendar component1) {
        this.setComponent1(component1);
        return this;
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate4(this.getComponent(1)));
        return result;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "30X";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<DATE4>";
    }

    public static Field30X get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("30X");
        if (t == null) {
            return null;
        }
        return new Field30X(t);
    }

    public static Field30X get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field30X.get(msg.getBlock4());
    }

    public static List<Field30X> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field30X.getAll(msg.getBlock4());
    }

    public static List<Field30X> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("30X");
        if (arr != null && arr.length > 0) {
            ArrayList<Field30X> result = new ArrayList<Field30X>(arr.length);
            for (Tag f : arr) {
                result.add(new Field30X(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 1;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 1) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 30X");
        }
        if (component == 1) {
            DateFormat f = DateFormat.getDateInstance(2, this.notNull(locale));
            Calendar cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Date");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "date");
        return result;
    }

    public static Field30X fromJson(String json) {
        Field30X field = new Field30X();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("date") != null) {
            field.setComponent1(jsonObject.get("date").getAsString());
        }
        return field;
    }
}

