/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field93C
extends Field
implements Serializable,
AmountContainer,
GenericField {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "93C";
    public static final String F_93C = "93C";
    public static final String PARSER_PATTERN = ":S//S/S/[c]N";
    public static final String COMPONENTS_PATTERN = "SSSSN";
    public static final Integer QUALIFIER = 1;
    public static final Integer QUANTITY_TYPE_CODE = 2;
    public static final Integer BALANCE_TYPE_CODE = 3;
    public static final Integer SIGN = 4;
    public static final Integer AMOUNT = 5;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field93C() {
        super(5);
    }

    public Field93C(String value) {
        super(value);
    }

    public Field93C(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"93C")) {
            throw new IllegalArgumentException("cannot create field 93C from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(5);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        this.setComponent2(SwiftParseUtils.getTokenFirst(toparse, "/"));
        this.setComponent3(SwiftParseUtils.getTokenSecond(toparse, "/"));
        String toparse2 = SwiftParseUtils.getTokenThirdLast(toparse, "/");
        this.setComponent4(SwiftParseUtils.getAlphaPrefix(toparse2));
        this.setComponent5(SwiftParseUtils.getNumericSuffix(toparse2));
    }

    public static Field93C newInstance(Field93C source) {
        Field93C cp = new Field93C();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        result.append("/");
        this.append(result, 4);
        this.append(result, 5);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("93C", value);
    }

    public static Tag emptyTag() {
        return new Tag("93C", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field93C setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field93C setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent2AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(2);
    }

    public String getQuantityTypeCode() {
        return this.getComponent(2);
    }

    public Field93C setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field93C setQuantityTypeCode(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent3AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(3);
    }

    public String getBalanceTypeCode() {
        return this.getComponent(3);
    }

    public Field93C setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field93C setBalanceTypeCode(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    @Deprecated
    public String getComponent4AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent4AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(4);
    }

    public String getSign() {
        return this.getComponent(4);
    }

    public Field93C setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field93C setSign(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public Number getComponent5AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(5));
    }

    public String getAmount() {
        return this.getComponent(5);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(5));
    }

    public Field93C setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field93C setComponent5(Number component5) {
        this.setComponent(5, SwiftFormatUtils.getNumber(component5));
        return this;
    }

    public Field93C setAmount(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field93C setAmount(Number component5) {
        this.setComponent5(component5);
        return this;
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int component) {
        return component == 4;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "93C";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//4!c/4!c/[<N>]<AMOUNT>15";
    }

    public static Field93C get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("93C");
        if (t == null) {
            return null;
        }
        return new Field93C(t);
    }

    public static Field93C get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field93C.get(msg.getBlock4());
    }

    public static List<Field93C> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field93C.getAll(msg.getBlock4());
    }

    public static List<Field93C> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("93C");
        if (arr != null && arr.length > 0) {
            ArrayList<Field93C> result = new ArrayList<Field93C>(arr.length);
            for (Tag f : arr) {
                result.add(new Field93C(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 93C");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            Number n = this.getComponent5AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Quantity Type Code");
        result.add("Balance Type Code");
        result.add("Sign");
        result.add("Amount");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "quantityTypeCode");
        result.put(3, "balanceTypeCode");
        result.put(4, "sign");
        result.put(5, "amount");
        return result;
    }

    public static Field93C fromJson(String json) {
        Field93C field = new Field93C();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("quantityTypeCode") != null) {
            field.setComponent2(jsonObject.get("quantityTypeCode").getAsString());
        }
        if (jsonObject.get("balanceTypeCode") != null) {
            field.setComponent3(jsonObject.get("balanceTypeCode").getAsString());
        }
        if (jsonObject.get("sign") != null) {
            field.setComponent4(jsonObject.get("sign").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent5(jsonObject.get("amount").getAsString());
        }
        return field;
    }
}

