/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt;

import com.prowidesoftware.swift.model.SwiftMessageUtils;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.mt.mt5xx.MT535;
import com.prowidesoftware.swift.model.mt.mt5xx.MT536;
import com.prowidesoftware.swift.model.mt.mt5xx.MT537;
import com.prowidesoftware.swift.model.mt.mt5xx.MT538;
import com.prowidesoftware.swift.model.mt.mt5xx.MT564;
import com.prowidesoftware.swift.model.mt.mt5xx.MT566;
import com.prowidesoftware.swift.model.mt.mt5xx.MT575;
import com.prowidesoftware.swift.model.mt.mt5xx.MT576;
import com.prowidesoftware.swift.model.mt.mt5xx.MT586;
import com.prowidesoftware.swift.model.mt.mt6xx.MT670;
import com.prowidesoftware.swift.model.mt.mt6xx.MT671;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class SequenceUtils {
    private SequenceUtils() {
        throw new AssertionError();
    }

    public static List<MT535.SequenceB1b1> resolveMT535GetSequenceB1b1List_sru2018(MT535 mt535) {
        Validate.notNull((Object)mt535);
        ArrayList<MT535.SequenceB1b1> result = new ArrayList<MT535.SequenceB1b1>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt535.getSequenceB1bList()).getSubBlocks("BREAK")) {
            MT535.SequenceB1b1 s = MT535.SequenceB1b1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT535.SequenceB1c> resolveMT535GetSequenceB1cList_sru2018(MT535 mt535) {
        Validate.notNull((Object)mt535);
        ArrayList<MT535.SequenceB1c> result = new ArrayList<MT535.SequenceB1c>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt535.getSequenceB1List()).getSubBlocks("BREAK")) {
            MT535.SequenceB1c s = MT535.SequenceB1c.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT536.SequenceA1> resolveMT536GetSequenceA1List_sru2018(MT536 mt536) {
        Validate.notNull((Object)mt536);
        ArrayList<MT536.SequenceA1> result = new ArrayList<MT536.SequenceA1>();
        for (SwiftTagListBlock seq : mt536.getSequenceA().getSubBlocks("LINK")) {
            MT536.SequenceA1 s = MT536.SequenceA1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT536.SequenceB1a1> resolveMT536GetSequenceB1a1List_sru2018(MT536 mt536) {
        Validate.notNull((Object)mt536);
        ArrayList<MT536.SequenceB1a1> result = new ArrayList<MT536.SequenceB1a1>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt536.getSequenceBList()).getSubBlocks("LINK")) {
            MT536.SequenceB1a1 s = MT536.SequenceB1a1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceA1> resolveMT537GetSequenceA1List_sru2018(MT537 mt537) {
        Validate.notNull((Object)mt537);
        ArrayList<MT537.SequenceA1> result = new ArrayList<MT537.SequenceA1>();
        for (SwiftTagListBlock seq : mt537.getSequenceA().getSubBlocks("LINK")) {
            MT537.SequenceA1 s = MT537.SequenceA1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceB> resolveMT537GetSequenceBList_sru2018(MT537 mt537) {
        return SequenceUtils.resolveMT537GetSequenceBList_sru2018(mt537.getSwiftMessage().getBlock4());
    }

    public static List<MT537.SequenceB> resolveMT537GetSequenceBList_sru2018(SwiftTagListBlock mt537) {
        Validate.notNull((Object)mt537);
        ArrayList<MT537.SequenceB> result = new ArrayList<MT537.SequenceB>();
        List<SwiftTagListBlock> raw = mt537.getSubBlockBeforeFirst("TRANS", false).getSubBlocks("STAT");
        if (raw == null) {
            return null;
        }
        for (SwiftTagListBlock swiftTagListBlock : raw) {
            MT537.SequenceB sequenceB = MT537.SequenceB.newInstance();
            sequenceB.getTags().clear();
            sequenceB.append(swiftTagListBlock);
            result.add(sequenceB);
        }
        return result;
    }

    public static List<MT537.SequenceB1> resolveMT537GetSequenceB1List_sru2018(MT537 mt537) {
        Validate.notNull((Object)mt537);
        ArrayList<MT537.SequenceB1> result = new ArrayList<MT537.SequenceB1>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt537.getSequenceBList()).getSubBlocks("REAS")) {
            MT537.SequenceB1 s = MT537.SequenceB1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceB2a> resolveMT537GetSequenceB2aList_sru2018(MT537 mt537) {
        Validate.notNull((Object)mt537);
        ArrayList<MT537.SequenceB2a> result = new ArrayList<MT537.SequenceB2a>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt537.getSequenceB2List()).getSubBlocks("LINK")) {
            MT537.SequenceB2a s = MT537.SequenceB2a.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceB2b1> resolveMT537GetSequenceB2b1List_sru2018(MT537 mt537) {
        Validate.notNull((Object)mt537);
        ArrayList<MT537.SequenceB2b1> result = new ArrayList<MT537.SequenceB2b1>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt537.getSequenceB2List()).getSubBlocks("SETPRTY")) {
            MT537.SequenceB2b1 s = MT537.SequenceB2b1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceC1> resolveMT537GetSequenceC1List_sru2018(MT537 mt537) {
        Validate.notNull((Object)mt537);
        ArrayList<MT537.SequenceC1> result = new ArrayList<MT537.SequenceC1>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt537.getSequenceCList()).getSubBlocks("LINK")) {
            MT537.SequenceC1 s = MT537.SequenceC1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceC2> resolveMT537GetSequenceC2List_sru2018(MT537 mt537) {
        Validate.notNull((Object)mt537);
        ArrayList<MT537.SequenceC2> result = new ArrayList<MT537.SequenceC2>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt537.getSequenceCList()).getSubBlocks("TRANSDET")) {
            MT537.SequenceC2 s = MT537.SequenceC2.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceC2a> resolveMT537GetSequenceC2aList_sru2018(MT537 mt537) {
        Validate.notNull((Object)mt537);
        ArrayList<MT537.SequenceC2a> result = new ArrayList<MT537.SequenceC2a>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt537.getSequenceC2List()).getSubBlocks("SETPRTY")) {
            MT537.SequenceC2a s = MT537.SequenceC2a.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceC3> resolveMT537GetSequenceC3List_sru2018(MT537 mt537) {
        Validate.notNull((Object)mt537);
        ArrayList<MT537.SequenceC3> result = new ArrayList<MT537.SequenceC3>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt537.getSequenceCList()).getSubBlocks("STAT")) {
            MT537.SequenceC3 s = MT537.SequenceC3.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceC3a> resolveMT537GetSequenceC3aList_sru2018(MT537 mt537) {
        Validate.notNull((Object)mt537);
        ArrayList<MT537.SequenceC3a> result = new ArrayList<MT537.SequenceC3a>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt537.getSequenceC3List()).getSubBlocks("REAS")) {
            MT537.SequenceC3a s = MT537.SequenceC3a.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT537.SequenceB2b> resolveMT537GetSequenceB2bList_sru2018(MT537 mt537) {
        Validate.notNull((Object)mt537);
        ArrayList<MT537.SequenceB2b> result = new ArrayList<MT537.SequenceB2b>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt537.getSequenceB2List()).getSubBlocks("TRANSDET")) {
            MT537.SequenceB2b s = MT537.SequenceB2b.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT538.SequenceA1> resolveMT538GetSequenceA1List_sru2018(MT538 mt538) {
        Validate.notNull((Object)mt538);
        ArrayList<MT538.SequenceA1> result = new ArrayList<MT538.SequenceA1>();
        for (SwiftTagListBlock seq : mt538.getSequenceA().getSubBlocks("LINK")) {
            MT538.SequenceA1 s = MT538.SequenceA1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT538.SequenceB2a1> resolveMT538GetSequenceB2a1List_sru2018(MT538 mt538) {
        Validate.notNull((Object)mt538);
        ArrayList<MT538.SequenceB2a1> result = new ArrayList<MT538.SequenceB2a1>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt538.getSequenceBList()).getSubBlocks("LINK")) {
            MT538.SequenceB2a1 s = MT538.SequenceB2a1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static MT564.SequenceB1 resolveMT564GetSequenceB1_sru2018(MT564 mt564) {
        Validate.notNull((Object)mt564);
        MT564.SequenceB1 result = MT564.SequenceB1.newInstance();
        result.clear().append(mt564.getSequenceB().getSubBlock("FIA"));
        return result;
    }

    public static List<MT564.SequenceE1a> resolveMT564GetSequenceE1aList_sru2018(MT564 mt564) {
        Validate.notNull((Object)mt564);
        ArrayList<MT564.SequenceE1a> result = new ArrayList<MT564.SequenceE1a>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt564.getSequenceEList()).getSubBlocks("FIA")) {
            MT564.SequenceE1a s = MT564.SequenceE1a.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT566.SequenceB1> resolveMT566GetSequenceB1List_sru2018(MT566 mt566) {
        Validate.notNull((Object)mt566);
        ArrayList<MT566.SequenceB1> result = new ArrayList<MT566.SequenceB1>();
        for (SwiftTagListBlock seq : mt566.getSequenceB().getSubBlocks("FIA")) {
            MT566.SequenceB1 s = MT566.SequenceB1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT566.SequenceD1a> resolveMT566GetSequenceD1aList_sru2018(MT566 mt566) {
        Validate.notNull((Object)mt566);
        ArrayList<MT566.SequenceD1a> result = new ArrayList<MT566.SequenceD1a>();
        for (SwiftTagListBlock seq : mt566.getSequenceD().getSubBlocks("FIA")) {
            MT566.SequenceD1a s = MT566.SequenceD1a.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT575.SequenceA1> resolveMT575GetSequenceA1List_sru2018(MT575 mt575) {
        Validate.notNull((Object)mt575);
        ArrayList<MT575.SequenceA1> result = new ArrayList<MT575.SequenceA1>();
        for (SwiftTagListBlock seq : mt575.getSequenceA().getSubBlocks("LINK")) {
            MT575.SequenceA1 s = MT575.SequenceA1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT575.SequenceB1a1> resolveMT575GetSequenceB1a1List_sru2018(MT575 mt575) {
        Validate.notNull((Object)mt575);
        ArrayList<MT575.SequenceB1a1> result = new ArrayList<MT575.SequenceB1a1>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt575.getSequenceB1aList()).getSubBlocks("LINK")) {
            MT575.SequenceB1a1 s = MT575.SequenceB1a1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT575.SequenceB1a4> resolveMT575GetSequenceB1a4List_sru2018(MT575 mt575) {
        Validate.notNull((Object)mt575);
        ArrayList<MT575.SequenceB1a4> result = new ArrayList<MT575.SequenceB1a4>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt575.getSequenceB1aList()).getSubBlocks("SETPRTY")) {
            MT575.SequenceB1a4 s = MT575.SequenceB1a4.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT575.SequenceC1> resolveMT575GetSequenceC1List_sru2018(MT575 mt575) {
        Validate.notNull((Object)mt575);
        ArrayList<MT575.SequenceC1> result = new ArrayList<MT575.SequenceC1>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt575.getSequenceCList()).getSubBlocks("LINK")) {
            MT575.SequenceC1 s = MT575.SequenceC1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT575.SequenceC2a> resolveMT575GetSequenceC2aList_sru2018(MT575 mt575) {
        Validate.notNull((Object)mt575);
        ArrayList<MT575.SequenceC2a> result = new ArrayList<MT575.SequenceC2a>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt575.getSequenceC2List()).getSubBlocks("SETPRTY")) {
            MT575.SequenceC2a s = MT575.SequenceC2a.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT576.SequenceA1> resolveMT576GetSequenceA1List_sru2018(MT576 mt576) {
        Validate.notNull((Object)mt576);
        ArrayList<MT576.SequenceA1> result = new ArrayList<MT576.SequenceA1>();
        for (SwiftTagListBlock seq : mt576.getSequenceA().getSubBlocks("LINK")) {
            MT576.SequenceA1 s = MT576.SequenceA1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT576.SequenceB2a> resolveMT576GetSequenceB2aList_sru2018(MT576 mt576) {
        Validate.notNull((Object)mt576);
        ArrayList<MT576.SequenceB2a> result = new ArrayList<MT576.SequenceB2a>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt576.getSequenceBList()).getSubBlocks("LINK")) {
            MT576.SequenceB2a s = MT576.SequenceB2a.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT586.SequenceA1> resolveMT586GetSequenceA1List_sru2018(MT586 mt586) {
        Validate.notNull((Object)mt586);
        ArrayList<MT586.SequenceA1> result = new ArrayList<MT586.SequenceA1>();
        for (SwiftTagListBlock seq : mt586.getSequenceA().getSubBlocks("LINK")) {
            MT586.SequenceA1 s = MT586.SequenceA1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT586.SequenceB1> resolveMT586GetSequenceB1List_sru2018(MT586 mt586) {
        Validate.notNull((Object)mt586);
        ArrayList<MT586.SequenceB1> result = new ArrayList<MT586.SequenceB1>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt586.getSequenceBList()).getSubBlocks("LINK")) {
            MT586.SequenceB1 s = MT586.SequenceB1.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static List<MT670.SequenceB2> resolveMT670GetSequenceB2List_sru2018(MT670 mt670) {
        Validate.notNull((Object)mt670);
        ArrayList<MT670.SequenceB2> result = new ArrayList<MT670.SequenceB2>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt670.getSequenceBList()).getSubBlocks("OTHRDET")) {
            MT670.SequenceB2 s = MT670.SequenceB2.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static MT670.SequenceC resolveMT670GetSequenceC_sru2018(MT670 mt670) {
        Validate.notNull((Object)mt670);
        MT670.SequenceC result = MT670.SequenceC.newInstance();
        result.clear().append(SequenceUtils.getMT670_1_C(mt670.getSwiftMessage().getBlock4(), "SSIDET"));
        return result;
    }

    public static List<MT671.SequenceB2> resolveMT671GetSequenceB2List_sru2018(MT671 mt671) {
        Validate.notNull((Object)mt671);
        ArrayList<MT671.SequenceB2> result = new ArrayList<MT671.SequenceB2>();
        for (SwiftTagListBlock seq : SwiftMessageUtils.join(mt671.getSequenceBList()).getSubBlocks("OTHRDET")) {
            MT671.SequenceB2 s = MT671.SequenceB2.newInstance();
            s.clear().append(seq);
            result.add(s);
        }
        return result;
    }

    public static MT671.SequenceC resolveMT671GetSequenceC_sru2018(MT671 mt671) {
        Validate.notNull((Object)mt671);
        MT671.SequenceC result = MT671.SequenceC.newInstance();
        result.clear().append(SequenceUtils.getMT670_1_C(mt671.getSwiftMessage().getBlock4(), "SSIDET"));
        return result;
    }

    private static SwiftTagListBlock getMT670_1_C(SwiftTagListBlock b4, String B_startEnd16rs) {
        int last = b4.indexOfLastValue("16S", B_startEnd16rs);
        if (last >= 0) {
            if (last + 1 == b4.size()) {
                return SwiftTagListBlock.EMPTY_LIST;
            }
            return b4.sublist(last, b4.size());
        }
        return b4;
    }
}

