/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt7xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field27;
import com.prowidesoftware.swift.model.field.Field45A;
import com.prowidesoftware.swift.model.field.Field46A;
import com.prowidesoftware.swift.model.field.Field47A;
import com.prowidesoftware.swift.model.field.Field49G;
import com.prowidesoftware.swift.model.field.Field49H;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT701
extends AbstractMT
implements Serializable {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT701.class.getName());
    public static final String NAME = "701";

    public MT701(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT701(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT701 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT701(m);
    }

    public MT701() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT701(String sender, String receiver) {
        super(701, sender, receiver);
    }

    @Deprecated
    public MT701(int messageType, String sender, String receiver) {
        super(701, sender, receiver);
        DeprecationUtils.phase3(this.getClass(), "MT701(int, String, String)", "Use the constructor MT701(sender, receiver) instead.");
    }

    public MT701(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT701.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT701 object from FIN content with a Service Message. Check if the MT701 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT701 object from FIN content with message type " + param.getType());
        }
    }

    public static MT701 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT701(fin);
    }

    public MT701(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT701 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT701(stream);
    }

    public MT701(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT701 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT701(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT701 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT701 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT701 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT701 fromJson(String json) {
        return (MT701)AbstractMT.fromJson(json);
    }

    public Field27 getField27() {
        Tag t = this.tag("27");
        if (t != null) {
            return new Field27(t.getValue());
        }
        return null;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field45A getField45A() {
        Tag t = this.tag("45A");
        if (t != null) {
            return new Field45A(t.getValue());
        }
        return null;
    }

    public Field46A getField46A() {
        Tag t = this.tag("46A");
        if (t != null) {
            return new Field46A(t.getValue());
        }
        return null;
    }

    public Field47A getField47A() {
        Tag t = this.tag("47A");
        if (t != null) {
            return new Field47A(t.getValue());
        }
        return null;
    }

    public Field49G getField49G() {
        Tag t = this.tag("49G");
        if (t != null) {
            return new Field49G(t.getValue());
        }
        return null;
    }

    public Field49H getField49H() {
        Tag t = this.tag("49H");
        if (t != null) {
            return new Field49H(t.getValue());
        }
        return null;
    }
}

