/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field14G
extends Field
implements Serializable {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "14G";
    public static final String F_14G = "14G";
    public static final String PARSER_PATTERN = "S/S";
    public static final String COMPONENTS_PATTERN = "SS";
    public static final Integer FREQUENCY = 1;
    public static final Integer METHOD = 2;

    public Field14G() {
        super(2);
    }

    public Field14G(String value) {
        super(value);
    }

    public Field14G(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"14G")) {
            throw new IllegalArgumentException("cannot create field 14G from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(value, "/"));
    }

    public static Field14G newInstance(Field14G source) {
        Field14G cp = new Field14G();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("14G", value);
    }

    public static Tag emptyTag() {
        return new Tag("14G", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getFrequency() {
        return this.getComponent(1);
    }

    public Field14G setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field14G setFrequency(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent2AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(2);
    }

    public String getMethod() {
        return this.getComponent(2);
    }

    public Field14G setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field14G setMethod(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "14G";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "1a/8!a";
    }

    public static Field14G get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("14G");
        if (t == null) {
            return null;
        }
        return new Field14G(t);
    }

    public static Field14G get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field14G.get(msg.getBlock4());
    }

    public static List<Field14G> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field14G.getAll(msg.getBlock4());
    }

    public static List<Field14G> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("14G");
        if (arr != null && arr.length > 0) {
            ArrayList<Field14G> result = new ArrayList<Field14G>(arr.length);
            for (Tag f : arr) {
                result.add(new Field14G(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 14G");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Frequency");
        result.add("Method");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "frequency");
        result.put(2, "method");
        return result;
    }

    public static Field14G fromJson(String json) {
        Field14G field = new Field14G();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("frequency") != null) {
            field.setComponent1(jsonObject.get("frequency").getAsString());
        }
        if (jsonObject.get("method") != null) {
            field.setComponent2(jsonObject.get("method").getAsString());
        }
        return field;
    }
}

