/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class XMLGregorianCalendarAdapter
implements JsonSerializer<XMLGregorianCalendar>,
JsonDeserializer<XMLGregorianCalendar> {
    private static final String YEAR = "year";
    private static final String MONTH = "month";
    private static final String DAY = "day";
    private static final String TIMEZONE = "timezone";
    private static final String HOUR = "hour";
    private static final String MINUTE = "minute";
    private static final String SECOND = "second";
    private static final String FRACTIONAL = "fractionalSecond";

    public JsonElement serialize(XMLGregorianCalendar cal, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject obj = new JsonObject();
        obj.addProperty(YEAR, (Number)cal.getYear());
        obj.addProperty(MONTH, (Number)cal.getMonth());
        obj.addProperty(DAY, (Number)cal.getDay());
        obj.addProperty(TIMEZONE, (Number)cal.getTimezone());
        obj.addProperty(HOUR, (Number)cal.getHour());
        obj.addProperty(MINUTE, (Number)cal.getMinute());
        obj.addProperty(SECOND, (Number)cal.getSecond());
        obj.addProperty(FRACTIONAL, (Number)cal.getFractionalSecond());
        return obj;
    }

    public XMLGregorianCalendar deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        try {
            JsonObject obj = jsonElement.getAsJsonObject();
            XMLGregorianCalendar xmlGregCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(obj.get(YEAR).getAsInt(), obj.get(MONTH).getAsInt(), obj.get(DAY).getAsInt(), obj.get(HOUR).getAsInt(), obj.get(MINUTE).getAsInt(), obj.get(SECOND).getAsInt(), 0, obj.get(TIMEZONE).getAsInt());
            xmlGregCalendar.setFractionalSecond(obj.get(FRACTIONAL).getAsBigDecimal());
            return xmlGregCalendar;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

