package ar.com.sdd.syndapi.io;

import ar.com.sdd.syndapi.model.OpenItem;
import com.fasterxml.jackson.annotation.*;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProcesarRetencionesRequest implements Serializable {

    @JsonProperty("trackingNumber")
    private String trackingNumber;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date processDate;

    @JsonProperty("paymentOrder")
    private String paymentOrder;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date documentDate;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date postingDate;

    @JsonProperty("company")
    private String company;

    @JsonProperty("documentType")
    private String documentType;

    @JsonProperty("currency")
    private String currency;

    @JsonProperty("payerCode")
    private String payerCode;

    @JsonProperty("amount")
    private Double amount;

    @JsonProperty("paymentMethod")
    private String paymentMethod;

    // Only for SEED & NIDE

    @JsonProperty("legalReference")
    private String legalReference;

    @JsonProperty("reference")
    private String reference;

    @JsonProperty("headerText")
    private String headerText;

    @JsonProperty("branch")
    private String branch;

    @JsonProperty("postingKey")
    private String postingKey;

    @JsonProperty("gl")
    private String gl;

    @JsonProperty("postingText")
    private String postingText;

    // Only for CROP

    @JsonProperty("division")
    private String division;

    @JsonProperty("reciboProvisorio")
    private String reciboProvisorio;

    @JsonProperty("tipoDeCobranza")
    private String tipoDeCobranza;

    @JsonProperty("estadoDeLaCobranza")
    private String estadoDeLaCobranza;

    @JsonProperty("tipoDeRetencion")
    private String tipoDeRetencion;

    @JsonProperty("claseDeRetencion")
    private String claseDeRetencion;

    @JsonProperty("porcentaje")
    private Double porcentaje;

    @JsonProperty("tipoDeComprobante")
    private String tipoDeComprobante;

    @JsonProperty("nroComprobanteAplicadoRetencion")
    private String nroComprobanteAplicadoRetencion;

    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public Date getProcessDate() {
        return processDate;
    }

    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }

    public String getPaymentOrder() {
        return paymentOrder;
    }

    public void setPaymentOrder(String paymentOrder) {
        this.paymentOrder = paymentOrder;
    }

    public Date getDocumentDate() {
        return documentDate;
    }

    public void setDocumentDate(Date documentDate) {
        this.documentDate = documentDate;
    }

    public Date getPostingDate() {
        return postingDate;
    }

    public void setPostingDate(Date postingDate) {
        this.postingDate = postingDate;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getDocumentType() {
        return documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    public Double getAmount() {
        return amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public String getPaymentMethod() {
        return paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public String getLegalReference() {
        return legalReference;
    }

    public void setLegalReference(String legalReference) {
        this.legalReference = legalReference;
    }

    public String getReference() {
        return reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getHeaderText() {
        return headerText;
    }

    public void setHeaderText(String headerText) {
        this.headerText = headerText;
    }

    public String getBranch() {
        return branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getPostingKey() {
        return postingKey;
    }

    public void setPostingKey(String postingKey) {
        this.postingKey = postingKey;
    }

    public String getGl() {
        return gl;
    }

    public void setGl(String gl) {
        this.gl = gl;
    }

    public String getPostingText() {
        return postingText;
    }

    public void setPostingText(String postingText) {
        this.postingText = postingText;
    }

    public String getDivision() {
        return division;
    }

    public void setDivision(String division) {
        this.division = division;
    }

    public String getReciboProvisorio() {
        return reciboProvisorio;
    }

    public void setReciboProvisorio(String reciboProvisorio) {
        this.reciboProvisorio = reciboProvisorio;
    }

    public String getTipoDeCobranza() {
        return tipoDeCobranza;
    }

    public void setTipoDeCobranza(String tipoDeCobranza) {
        this.tipoDeCobranza = tipoDeCobranza;
    }

    public String getEstadoDeLaCobranza() {
        return estadoDeLaCobranza;
    }

    public void setEstadoDeLaCobranza(String estadoDeLaCobranza) {
        this.estadoDeLaCobranza = estadoDeLaCobranza;
    }

    public String getTipoDeRetencion() {
        return tipoDeRetencion;
    }

    public void setTipoDeRetencion(String tipoDeRetencion) {
        this.tipoDeRetencion = tipoDeRetencion;
    }

    public String getClaseDeRetencion() {
        return claseDeRetencion;
    }

    public void setClaseDeRetencion(String claseDeRetencion) {
        this.claseDeRetencion = claseDeRetencion;
    }

    public Double getPorcentaje() {
        return porcentaje;
    }

    public void setPorcentaje(Double porcentaje) {
        this.porcentaje = porcentaje;
    }

    public String getTipoDeComprobante() {
        return tipoDeComprobante;
    }

    public void setTipoDeComprobante(String tipoDeComprobante) {
        this.tipoDeComprobante = tipoDeComprobante;
    }

    public String getNroComprobanteAplicadoRetencion() {
        return nroComprobanteAplicadoRetencion;
    }

    public void setNroComprobanteAplicadoRetencion(String nroComprobanteAplicadoRetencion) {
        this.nroComprobanteAplicadoRetencion = nroComprobanteAplicadoRetencion;
    }

    @Override
    public String toString() {
        return "ProcesarRetencionesRequest [" +
                ((trackingNumber != null) ? "trackingNumber=" + trackingNumber + ", " : "") +
                ((processDate != null) ? "processDate=" + processDate + ", " : "") +
                ((paymentOrder != null) ? "paymentOrder=" + paymentOrder + ", " : "") +
                ((documentDate != null) ? "documentDate=" + documentDate + ", " : "") +
                ((postingDate != null) ? "postingDate=" + postingDate + ", " : "") +
                ((company != null) ? "company=" + company + ", " : "") +
                ((documentType != null) ? "documentType=" + documentType + ", " : "") +
                ((currency != null) ? "currency=" + currency + ", " : "") +
                ((payerCode != null) ? "payerCode=" + payerCode + ", " : "") +
                ((amount != null) ? "amount=" + amount + ", " : "") +
                ((paymentMethod != null) ? "paymentMethod=" + paymentMethod + ", " : "") +
                ((legalReference != null) ? "legalReference=" + legalReference + ", " : "") +
                ((reference != null) ? "reference=" + reference + ", " : "") +
                ((headerText != null) ? "headerText=" + headerText + ", " : "") +
                ((branch != null) ? "branch=" + branch + ", " : "") +
                ((postingKey != null) ? "postingKey=" + postingKey + ", " : "") +
                ((gl != null) ? "gl=" + gl + ", " : "") +
                ((postingText != null) ? "postingText=" + postingText + ", " : "") +
                ((division != null) ? "division=" + division + ", " : "") +
                ((reciboProvisorio != null) ? "reciboProvisorio=" + reciboProvisorio + ", " : "") +
                ((tipoDeCobranza != null) ? "tipoDeCobranza=" + tipoDeCobranza + ", " : "") +
                ((estadoDeLaCobranza != null) ? "estadoDeLaCobranza=" + estadoDeLaCobranza + ", " : "") +
                ((tipoDeRetencion != null) ? "tipoDeRetencion=" + tipoDeRetencion + ", " : "") +
                ((claseDeRetencion != null) ? "claseDeRetencion=" + claseDeRetencion + ", " : "") +
                ((porcentaje != null) ? "porcentaje=" + porcentaje + ", " : "") +
                ((tipoDeComprobante != null) ? "tipoDeComprobante=" + tipoDeComprobante + ", " : "") +
                ((nroComprobanteAplicadoRetencion != null) ? "nroComprobanteAplicadoRetencion=" + nroComprobanteAplicadoRetencion + ", " : "") +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProcesarRetencionesRequest that = (ProcesarRetencionesRequest) o;
        return Objects.equals(trackingNumber, that.trackingNumber) && Objects.equals(processDate, that.processDate) && Objects.equals(paymentOrder, that.paymentOrder) && Objects.equals(documentDate, that.documentDate) && Objects.equals(postingDate, that.postingDate) && Objects.equals(company, that.company) && Objects.equals(documentType, that.documentType) && Objects.equals(currency, that.currency) && Objects.equals(payerCode, that.payerCode) && Objects.equals(amount, that.amount) && Objects.equals(paymentMethod, that.paymentMethod) && Objects.equals(legalReference, that.legalReference) && Objects.equals(reference, that.reference) && Objects.equals(headerText, that.headerText) && Objects.equals(branch, that.branch) && Objects.equals(postingKey, that.postingKey) && Objects.equals(gl, that.gl) && Objects.equals(postingText, that.postingText) && Objects.equals(division, that.division) && Objects.equals(reciboProvisorio, that.reciboProvisorio) && Objects.equals(tipoDeCobranza, that.tipoDeCobranza) && Objects.equals(estadoDeLaCobranza, that.estadoDeLaCobranza) && Objects.equals(tipoDeRetencion, that.tipoDeRetencion) && Objects.equals(claseDeRetencion, that.claseDeRetencion) && Objects.equals(porcentaje, that.porcentaje) && Objects.equals(tipoDeComprobante, that.tipoDeComprobante) && Objects.equals(nroComprobanteAplicadoRetencion, that.nroComprobanteAplicadoRetencion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(trackingNumber, processDate, paymentOrder, documentDate, postingDate, company, documentType, currency, payerCode, amount, paymentMethod, legalReference, reference, headerText, branch, postingKey, gl, postingText, division, reciboProvisorio, tipoDeCobranza, estadoDeLaCobranza, tipoDeRetencion, claseDeRetencion, porcentaje, tipoDeComprobante, nroComprobanteAplicadoRetencion);
    }
}