/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.syndapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.util.RestConnectorUtil;
import ar.com.sdd.syndapi.core.SyndApiConnectorContext;
import ar.com.sdd.syndapi.io.ProcesarCobranzaRequest;
import ar.com.sdd.syndapi.io.ProcesarPaseCuentasRequest;
import ar.com.sdd.syndapi.io.ProcesarRetencionesRequest;
import javax.ws.rs.client.Invocation;
import org.apache.log4j.Logger;

public class SyndApiConnector
implements RestSecurityManager {
    private static final Logger log = Logger.getLogger(SyndApiConnector.class);
    private final RestConnector restConnector;
    private final String username;
    private final String password;

    public SyndApiConnector(SyndApiConnectorContext context) {
        this.username = context.getSyndApiUsername();
        this.password = context.getSyndApiPassword();
        log.debug((Object)("Creando SyndApiConnector para url [" + context.getSyndApiBaseUrl() + "], username [" + this.username + "], password [" + this.password + "]"));
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getSyndApiBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public void procesarCobranza(ProcesarCobranzaRequest request) throws RestConnectorException {
        String path = "/BufferPayment";
        log.debug((Object)("[procesarCobranza] Request POST procesar cobranza, request [" + request + "] path [" + path + "]"));
        this.restConnector.genericPost((Object)request, Void.class, path);
    }

    public void procesarPaseCuentas(ProcesarPaseCuentasRequest request) throws RestConnectorException {
        String path = "/BufferPaseCuentas";
        log.debug((Object)("[procesarPaseCuentas] Request POST procesar pase cuentas, request [" + request + "] path [" + path + "]"));
        this.restConnector.genericPost((Object)request, Void.class, path);
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("Authorization", (Object)RestConnectorUtil.getBasicAuthHeader((String)this.username, (String)this.password));
        }
        return builder;
    }

    public void procesarRetenciones(ProcesarRetencionesRequest request) throws RestConnectorException {
        String path = "/BufferWHT";
        log.debug((Object)("[procesarRetenciones] Request POST procesar retenciones, request [" + request + "] path [" + path + "]"));
        this.restConnector.genericPost((Object)request, Void.class, path);
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }
}

