package ar.com.sdd.syndapi.io;

import ar.com.sdd.syndapi.model.OpenItem;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ProcesarCobranzaRequest implements Serializable {

    private String trackingNumber;
    private String paymentOrder;
    private String biller;
    private String payerCode;
    private List<OpenItem> openItems;

    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public String getPaymentOrder() {
        return paymentOrder;
    }

    public void setPaymentOrder(String paymentOrder) {
        this.paymentOrder = paymentOrder;
    }

    public String getBiller() {
        return biller;
    }

    public void setBiller(String biller) {
        this.biller = biller;
    }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    public List<OpenItem> getOpenItems() {
        return openItems;
    }

    public void setOpenItems(List<OpenItem> openItems) {
        this.openItems = openItems;
    }

    @Override
    public String toString() {
        return "ProcesarCobranzaRequest ["
                + ((trackingNumber != null) ? "trackingNumber=" + trackingNumber + ", " : "")
                + ((paymentOrder != null) ? "paymentOrder=" + paymentOrder + ", " : "")
                + ((biller != null) ? "biller=" + biller + ", " : "")
                + ((payerCode != null) ? "payerCode=" + payerCode + ", " : "")
                + ((openItems != null) ? "openItems=" + Arrays.toString(openItems.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProcesarCobranzaRequest that = (ProcesarCobranzaRequest) o;
        return Objects.equals(trackingNumber, that.trackingNumber) && Objects.equals(paymentOrder, that.paymentOrder) && Objects.equals(biller, that.biller) && Objects.equals(payerCode, that.payerCode) && Objects.equals(openItems, that.openItems);
    }

    @Override
    public int hashCode() {
        return Objects.hash(trackingNumber, paymentOrder, biller, payerCode, openItems);
    }
}