package ar.com.sdd.syndapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

public class OpenItem implements Serializable {

    private String docYear;
    private String docNumber;
    private String docPos;
    private String currency;

    public String getDocYear() {
        return docYear;
    }

    public void setDocYear(String docYear) {
        this.docYear = docYear;
    }

    public String getDocNumber() {
        return docNumber;
    }

    public void setDocNumber(String docNumber) {
        this.docNumber = docNumber;
    }

    public String getDocPos() {
        return docPos;
    }

    public void setDocPos(String docPos) {
        this.docPos = docPos;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Override
    public String toString() {
        return "OpenItem ["
                + ((docYear != null) ? "docYear=" + docYear + ", " : "")
                + ((docNumber != null) ? "docNumber=" + docNumber + ", " : "")
                + ((docPos != null) ? "docPos=" + docPos + ", " : "")
                + ((currency != null) ? "currency=" + currency : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OpenItem openItem = (OpenItem) o;
        return Objects.equals(docYear, openItem.docYear) && Objects.equals(docNumber, openItem.docNumber) && Objects.equals(docPos, openItem.docPos) && Objects.equals(currency, openItem.currency);
    }

    @Override
    public int hashCode() {
        return Objects.hash(docYear, docNumber, docPos, currency);
    }
}