/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.syndapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.util.RestConnectorUtil;
import ar.com.sdd.syndapi.core.SyndApiConnectorContext;
import ar.com.sdd.syndapi.io.ProcesarCobranzaRequest;
import ar.com.sdd.syndapi.io.ProcesarCobranzaResponse;
import javax.ws.rs.client.Invocation;
import org.apache.log4j.Logger;

public class SyndApiConnector
implements RestSecurityManager {
    private static final Logger log = Logger.getLogger(SyndApiConnector.class);
    private final RestConnector restConnector;
    private final String username;
    private final String password;

    public SyndApiConnector(SyndApiConnectorContext context) {
        this.username = context.getSyndApiUsername();
        this.password = context.getSyndApiPassword();
        log.debug((Object)("Creando SyndApiConnector para url [" + context.getSyndApiBaseUrl() + "], username [" + this.username + "], password [" + this.password + "]"));
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getSyndApiBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public ProcesarCobranzaResponse procesarCobranza(ProcesarCobranzaRequest request) throws RestConnectorException {
        String path = "/BufferPayment";
        log.debug((Object)("[procesarCobranza] Request POST procesar cobranza, request [" + request + "] path [" + path + "]"));
        ProcesarCobranzaResponse response = (ProcesarCobranzaResponse)this.restConnector.genericPost((Object)request, ProcesarCobranzaResponse.class, path);
        log.debug((Object)("[procesarCobranza] Response POST procesar cobranza [" + response + "]"));
        return response;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("Authorization", (Object)RestConnectorUtil.getBasicAuthHeader((String)this.username, (String)this.password));
        }
        return builder;
    }
}

