package ar.com.sdd.syndapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.util.RestConnectorUtil;
import ar.com.sdd.syndapi.io.ProcesarCobranzaRequest;
import ar.com.sdd.syndapi.io.ProcesarCobranzaResponse;
import org.apache.log4j.Logger;

import javax.ws.rs.client.Invocation;

public class SyndApiConnector implements RestSecurityManager {

    private final static Logger log = Logger.getLogger(SyndApiConnector.class);

    private final RestConnector restConnector;
    private final String username;
    private final String password;

    public SyndApiConnector(SyndApiConnectorContext context) {
        this.username = context.getSyndApiUsername();
        this.password = context.getSyndApiPassword();

        log.debug("Creando SyndApiConnector para url [" + context.getSyndApiBaseUrl() + "], username [" + username + "], password [" + password + "]");

        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getSyndApiBaseUrl());
        restConnector = new RestConnector(environment, this);
    }

    public void procesarCobranza(ProcesarCobranzaRequest request) throws RestConnectorException {
        String path = "/BufferPayment";
        log.debug("[procesarCobranza] Request POST procesar cobranza, request [" + request + "] path [" + path + "]");
        restConnector.genericPost(request, Void.class, path);
    }

    @Override
    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("Authorization", RestConnectorUtil.getBasicAuthHeader(username, password));
        }
        return builder;
    }
}
