package ar.com.sdd.syndapi.io;

import ar.com.sdd.syndapi.model.OpenItem;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProcesarCobranzaRequest implements Serializable {

    @JsonProperty(value = "trackingNumber")
    private String trackingNumber;

    @JsonProperty(value = "paymentOrder")
    private String paymentOrder;

    @JsonProperty(value = "biller")
    private String biller;

    @JsonProperty(value = "payerCode")
    private String payerCode;

    @JsonProperty(value = "openItem")
    private List<OpenItem> openItem;

    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public String getPaymentOrder() {
        return paymentOrder;
    }

    public void setPaymentOrder(String paymentOrder) {
        this.paymentOrder = paymentOrder;
    }

    public String getBiller() {
        return biller;
    }

    public void setBiller(String biller) {
        this.biller = biller;
    }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    public List<OpenItem> getOpenItem() {
        return openItem;
    }

    public void setOpenItem(List<OpenItem> openItem) {
        this.openItem = openItem;
    }

    @Override
    public String toString() {
        return "ProcesarCobranzaRequest ["
                + ((trackingNumber != null) ? "trackingNumber=" + trackingNumber + ", " : "")
                + ((paymentOrder != null) ? "paymentOrder=" + paymentOrder + ", " : "")
                + ((biller != null) ? "biller=" + biller + ", " : "")
                + ((payerCode != null) ? "payerCode=" + payerCode + ", " : "")
                + ((openItem != null) ? "openItems=" + Arrays.toString(openItem.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProcesarCobranzaRequest that = (ProcesarCobranzaRequest) o;
        return Objects.equals(trackingNumber, that.trackingNumber) && Objects.equals(paymentOrder, that.paymentOrder) && Objects.equals(biller, that.biller) && Objects.equals(payerCode, that.payerCode) && Objects.equals(openItem, that.openItem);
    }

    @Override
    public int hashCode() {
        return Objects.hash(trackingNumber, paymentOrder, biller, payerCode, openItem);
    }
}