package ar.com.sdd.syndapi.io;

import ar.com.sdd.syndapi.model.OpenItem;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProcesarPaseCuentasRequest implements Serializable {

    @JsonProperty(value = "trackingNumber")
    private String trackingNumber;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date issueDate;

    @JsonProperty(value = "biller")
    private String biller;

    @JsonProperty(value = "payerCode")
    private String payerCode;

    @JsonProperty(value = "billerTo")
    private String billerTo;

    @JsonProperty(value = "payerCodeTo")
    private String payerCodeTo;

    @JsonProperty(value = "openItem")
    private List<OpenItem> openItem;

    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public String getBiller() {
        return biller;
    }

    public void setBiller(String biller) {
        this.biller = biller;
    }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    public String getBillerTo() {
        return billerTo;
    }

    public void setBillerTo(String billerTo) {
        this.billerTo = billerTo;
    }

    public String getPayerCodeTo() {
        return payerCodeTo;
    }

    public void setPayerCodeTo(String payerCodeTo) {
        this.payerCodeTo = payerCodeTo;
    }

    public List<OpenItem> getOpenItem() {
        return openItem;
    }

    public void setOpenItem(List<OpenItem> openItem) {
        this.openItem = openItem;
    }

    @Override
    public String toString() {
        return "ProcesarPaseCuentasRequest ["
                + ((trackingNumber != null) ? "trackingNumber=" + trackingNumber + ", " : "")
                + ((issueDate != null) ? "issueDate=" + issueDate + ", " : "")
                + ((biller != null) ? "biller=" + biller + ", " : "")
                + ((payerCode != null) ? "payerCode=" + payerCode + ", " : "")
                + ((billerTo != null) ? "billerTo=" + billerTo + ", " : "")
                + ((payerCodeTo != null) ? "payerCodeTo=" + payerCodeTo + ", " : "")
                + ((openItem != null) ? "openItem=" + Arrays.toString(openItem.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProcesarPaseCuentasRequest that = (ProcesarPaseCuentasRequest) o;
        return Objects.equals(trackingNumber, that.trackingNumber) && Objects.equals(issueDate, that.issueDate) && Objects.equals(biller, that.biller) && Objects.equals(payerCode, that.payerCode) && Objects.equals(billerTo, that.billerTo) && Objects.equals(payerCodeTo, that.payerCodeTo) && Objects.equals(openItem, that.openItem);
    }

    @Override
    public int hashCode() {
        return Objects.hash(trackingNumber, issueDate, biller, payerCode, billerTo, payerCodeTo, openItem);
    }
}