package ar.com.sdd.syndapi.io;

import ar.com.sdd.syndapi.model.OpenItem;
import com.fasterxml.jackson.annotation.*;
import org.apache.commons.lang3.EnumUtils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProcesarCobranzaRequest implements Serializable {

    @JsonProperty("trackingNumber")
    private String trackingNumber;

    @JsonProperty("paymentOrder")
    private String paymentOrder;

    @JsonProperty("biller")
    private String biller;

    @JsonProperty("payerCode")
    private String payerCode;


    public enum ModoAplicacionIVA {
        INCREMENTAL("INCREMENTAL"),
        CONTENIDO("CONTENIDO")
        ;
        private String value;
        ModoAplicacionIVA(String value) {
            this.value = value;
        }
        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }
    @JsonProperty("modoAplicacionIVA")
    private ModoAplicacionIVA modoAplicacionIVA;

    public enum ModoAplicacionUSD {
        PROCESS_CURRENCY("PROCESS_CURRENCY"),
        FULLARS("FULLARS")
        ;
        private String value;
        ModoAplicacionUSD(String value) {
            this.value = value;
        }
        @Override
        @JsonValue
        public String toString() {
            return String.valueOf(value);
        }
    }
    @JsonProperty("modoAplicacionUSD")
    private ModoAplicacionUSD modoAplicacionUSD;

    @JsonProperty("openItem")
    private List<OpenItem> openItem;

    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public String getPaymentOrder() {
        return paymentOrder;
    }

    public void setPaymentOrder(String paymentOrder) {
        this.paymentOrder = paymentOrder;
    }

    public String getBiller() {
        return biller;
    }

    public void setBiller(String biller) {
        this.biller = biller;
    }

    public ModoAplicacionIVA getModoAplicacionIVA() { return modoAplicacionIVA; }
    public void setModoAplicacionIVA(ModoAplicacionIVA modoAplicacionIVA) { this.modoAplicacionIVA = modoAplicacionIVA;}
    public ModoAplicacionUSD getModoAplicacionUSD() { return modoAplicacionUSD; }
    public void setModoAplicacionUSD(ModoAplicacionUSD modoAplicacionUSD) { this.modoAplicacionUSD = modoAplicacionUSD; }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    public List<OpenItem> getOpenItem() {
        return openItem;
    }

    public void setOpenItem(List<OpenItem> openItem) {
        this.openItem = openItem;
    }

    @Override
    public String toString() {
        return "ProcesarCobranzaRequest ["
                + ((trackingNumber != null) ? "trackingNumber=" + trackingNumber + ", " : "")
                + ((paymentOrder != null) ? "paymentOrder=" + paymentOrder + ", " : "")
                + ((biller != null) ? "biller=" + biller + ", " : "")
                + ((payerCode != null) ? "payerCode=" + payerCode + ", " : "")
                + ((openItem != null) ? "openItems=" + Arrays.toString(openItem.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProcesarCobranzaRequest that = (ProcesarCobranzaRequest) o;
        return Objects.equals(trackingNumber, that.trackingNumber) && Objects.equals(paymentOrder, that.paymentOrder) && Objects.equals(biller, that.biller) && Objects.equals(payerCode, that.payerCode) && Objects.equals(openItem, that.openItem);
    }

    @Override
    public int hashCode() {
        return Objects.hash(trackingNumber, paymentOrder, biller, payerCode, openItem);
    }
}