/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.tasa.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2;
import ar.com.sdd.commons.rest.util.QueryBuilder;
import ar.com.sdd.tasa.core.TasaConnectorContext;
import ar.com.sdd.tasa.entity.InvoiceListItem;
import ar.com.sdd.tasa.entity.InvoiceListItems;
import java.util.Date;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import org.apache.log4j.Logger;

public class TasaConnector
implements RestSecurityManager {
    private static final Logger log = Logger.getLogger(TasaConnector.class);
    private RestConnector restConnector;
    private String clientId;
    private String clientSecret;

    public TasaConnector(TasaConnectorContext tasaConnectorContext) {
        this(tasaConnectorContext.getTasaBaseUrl(), tasaConnectorContext.getTasaClientId(), tasaConnectorContext.getTasaClientSecret());
    }

    public TasaConnector(String baseUrl, String clientId, String clientSecret) {
        log.debug((Object)("Creando connector con baseUrl [" + baseUrl + "], clientId [" + clientId + "], clientSecret [" + clientSecret + "]"));
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        RestConnectorEnvironment environment = new RestConnectorEnvironment(baseUrl, null, null, null, null);
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public InvoiceListItems getInvoices(String cuit, InvoiceListItem.LineOfBusiness lineOfBusiness, Date fromDueDate, Date toDueDate) throws RestConnectorException {
        QueryBuilder queryBuilder = QueryBuilder.Builder().path("/billingmanagement/eerr/v1/invoices").add("tipoDocumento", "CUIT").add("numeroDocumento", cuit).add("lineOfBusiness", lineOfBusiness.name());
        if (fromDueDate != null) {
            queryBuilder.add("fromDueDate", fromDueDate);
        }
        if (toDueDate != null) {
            queryBuilder.add("toDueDate", toDueDate);
        }
        String path = queryBuilder.build();
        log.debug((Object)("[getInvoices] Request GET invoices con cuit [" + cuit + "], lineOfBusiness [" + (Object)((Object)lineOfBusiness) + "], fromDueDate [" + fromDueDate + "], toDueDate [" + toDueDate + "], path [" + path + "]"));
        InvoiceListItems response = (InvoiceListItems)this.restConnector.genericGet(null, InvoiceListItems.class, path);
        log.debug((Object)("[getInvoices] Response GET invoices [" + response + "]"));
        return response;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        TokenOAuth2 token = this.getToken();
        log.trace((Object)("[addHeaders] Token recuperado [" + token + "]"));
        builder.header("authorization", (Object)("Bearer " + token.getAccessToken()));
        builder.header("x-ibm-client-id", (Object)this.clientId);
        return builder;
    }

    private TokenOAuth2 getToken() throws RestConnectorException {
        Form form = new Form();
        form.param("client_id", this.clientId);
        form.param("client_secret", this.clientSecret);
        form.param("grant_type", "client_credentials");
        log.debug((Object)("[getToken] Por recuperar token con clientId [" + this.clientId + "], clientSecret [" + this.clientSecret + "]"));
        TokenOAuth2 tokenOAuth2Response = (TokenOAuth2)this.restConnector.genericPost((Object)form, TokenOAuth2.class, "/v1/oauth2/token", "application/json", "application/x-www-form-urlencoded");
        log.debug((Object)("[getToken] Token recuperado [" + tokenOAuth2Response + "]"));
        return tokenOAuth2Response;
    }
}

