package ar.com.sdd.tasa.io;

import ar.com.sdd.tasa.core.TasaConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.math.BigDecimal;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentRequest {

    @JsonProperty("ANI")
    private String ani;
    private TasaConst.PaymentMethod paymentMethod;
    private BigDecimal amount;
    private TasaConst.Moneda currency;
    private String accountId;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMdd", timezone = "GMT-03:00")
    private Date depositDate;
    private String paymentSourceType;
    private String paymentSourceId;
    private String billingInvoiceNumber;
    private String externalTransactionId;

    public String getAni() {
        return ani;
    }

    public void setAni(String ani) {
        this.ani = ani;
    }

    public TasaConst.PaymentMethod getPaymentMethod() {
        return paymentMethod;
    }

    public void setPaymentMethod(TasaConst.PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public TasaConst.Moneda getCurrency() {
        return currency;
    }

    public void setCurrency(TasaConst.Moneda currency) {
        this.currency = currency;
    }

    public String getAccountId() {
        return accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public Date getDepositDate() {
        return depositDate;
    }

    public void setDepositDate(Date depositDate) {
        this.depositDate = depositDate;
    }

    public String getPaymentSourceType() {
        return paymentSourceType;
    }

    public void setPaymentSourceType(String paymentSourceType) {
        this.paymentSourceType = paymentSourceType;
    }

    public String getPaymentSourceId() {
        return paymentSourceId;
    }

    public void setPaymentSourceId(String paymentSourceId) {
        this.paymentSourceId = paymentSourceId;
    }

    public String getBillingInvoiceNumber() {
        return billingInvoiceNumber;
    }

    public void setBillingInvoiceNumber(String billingInvoiceNumber) {
        this.billingInvoiceNumber = billingInvoiceNumber;
    }

    public String getExternalTransactionId() {
        return externalTransactionId;
    }

    public void setExternalTransactionId(String externalTransactionId) {
        this.externalTransactionId = externalTransactionId;
    }

    @Override
    public String toString() {
        return "PaymentRequest ["
                + ((ani != null) ? "ani=" + ani + ", " : "")
                + ((paymentMethod != null) ? "paymentMethod=" + paymentMethod + ", " : "")
                + ((amount != null) ? "amount=" + amount + ", " : "")
                + ((currency != null) ? "currency=" + currency + ", " : "")
                + ((accountId != null) ? "accountId=" + accountId + ", " : "")
                + ((depositDate != null) ? "depositDate=" + depositDate + ", " : "")
                + ((paymentSourceType != null) ? "paymentSourceType=" + paymentSourceType + ", " : "")
                + ((paymentSourceId != null) ? "paymentSourceId=" + paymentSourceId + ", " : "")
                + ((billingInvoiceNumber != null) ? "billingInvoiceNumber=" + billingInvoiceNumber + ", " : "")
                + ((externalTransactionId != null) ? "externalTransactionId=" + externalTransactionId : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PaymentRequest that = (PaymentRequest) o;

        if (ani != null ? !ani.equals(that.ani) : that.ani != null) return false;
        if (paymentMethod != that.paymentMethod) return false;
        if (amount != null ? !amount.equals(that.amount) : that.amount != null) return false;
        if (currency != that.currency) return false;
        if (accountId != null ? !accountId.equals(that.accountId) : that.accountId != null) return false;
        if (depositDate != null ? !depositDate.equals(that.depositDate) : that.depositDate != null) return false;
        if (paymentSourceType != null ? !paymentSourceType.equals(that.paymentSourceType) : that.paymentSourceType != null)
            return false;
        if (paymentSourceId != null ? !paymentSourceId.equals(that.paymentSourceId) : that.paymentSourceId != null)
            return false;
        if (billingInvoiceNumber != null ? !billingInvoiceNumber.equals(that.billingInvoiceNumber) : that.billingInvoiceNumber != null)
            return false;
        return externalTransactionId != null ? externalTransactionId.equals(that.externalTransactionId) : that.externalTransactionId == null;
    }

    @Override
    public int hashCode() {
        int result = ani != null ? ani.hashCode() : 0;
        result = 31 * result + (paymentMethod != null ? paymentMethod.hashCode() : 0);
        result = 31 * result + (amount != null ? amount.hashCode() : 0);
        result = 31 * result + (currency != null ? currency.hashCode() : 0);
        result = 31 * result + (accountId != null ? accountId.hashCode() : 0);
        result = 31 * result + (depositDate != null ? depositDate.hashCode() : 0);
        result = 31 * result + (paymentSourceType != null ? paymentSourceType.hashCode() : 0);
        result = 31 * result + (paymentSourceId != null ? paymentSourceId.hashCode() : 0);
        result = 31 * result + (billingInvoiceNumber != null ? billingInvoiceNumber.hashCode() : 0);
        result = 31 * result + (externalTransactionId != null ? externalTransactionId.hashCode() : 0);
        return result;
    }
}
