package ar.com.sdd.tasa.io;

import ar.com.sdd.tasa.core.TasaConst;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class PaymentResponse {

    private Long paymentId;
    private TasaConst.PaymentStatus paymentStatus;

    public Long getPaymentId() {
        return paymentId;
    }

    public void setPaymentId(Long paymentId) {
        this.paymentId = paymentId;
    }

    public TasaConst.PaymentStatus getPaymentStatus() {
        return paymentStatus;
    }

    public void setPaymentStatus(TasaConst.PaymentStatus paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    @Override
    public String toString() {
        return "PaymentResponse ["
                + ((paymentId != null) ? "paymentId=" + paymentId + ", " : "")
                + ((paymentStatus != null) ? "paymentStatus=" + paymentStatus : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PaymentResponse that = (PaymentResponse) o;

        if (paymentId != null ? !paymentId.equals(that.paymentId) : that.paymentId != null) return false;
        return paymentStatus == that.paymentStatus;
    }

    @Override
    public int hashCode() {
        int result = paymentId != null ? paymentId.hashCode() : 0;
        result = 31 * result + (paymentStatus != null ? paymentStatus.hashCode() : 0);
        return result;
    }
}
