/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.tasa.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2;
import ar.com.sdd.commons.rest.util.QueryBuilder;
import ar.com.sdd.tasa.core.TasaConnectorContext;
import ar.com.sdd.tasa.core.TasaConst;
import ar.com.sdd.tasa.entity.InvoiceListItem;
import ar.com.sdd.tasa.io.PaymentRequest;
import ar.com.sdd.tasa.io.PaymentResponse;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import org.apache.log4j.Logger;

public class TasaConnector
implements RestSecurityManager {
    private static final Logger log = Logger.getLogger(TasaConnector.class);
    public static final SimpleDateFormat sdfTasa = new SimpleDateFormat("yyyyMMdd");
    private RestConnectorEnvironment environment;
    private RestConnector restConnector;
    private String clientId;
    private String clientSecret;
    private String scope;

    public TasaConnector(TasaConnectorContext tasaConnectorContext) {
        String baseUrl = tasaConnectorContext.getTasaBaseUrl();
        String clientId = tasaConnectorContext.getTasaClientId();
        String clientSecret = tasaConnectorContext.getTasaClientSecret();
        String scope = tasaConnectorContext.getTasaScope();
        String targetNameFijo = tasaConnectorContext.getTargetNameFijo();
        String targetNameMovil = tasaConnectorContext.getTargetNameMovil();
        String targetNameAmdocs = tasaConnectorContext.getTargetNameAmdocs();
        String importTaskFijo = tasaConnectorContext.getImportTaskFijo();
        String importTaskMovil = tasaConnectorContext.getImportTaskMovil();
        String importTaskAmdocs = tasaConnectorContext.getImportTaskAmdocs();
        log.debug((Object)("Creando connector Tasa con baseUrl [" + baseUrl + "], clientId [" + clientId + "], clientSecret [" + clientSecret + "], scope [" + scope + "], targetNameFijo [" + targetNameFijo + "], targetNameMovil [" + targetNameMovil + "], targetNameAmdocs [" + targetNameAmdocs + "] importTaskFijo [" + importTaskFijo + "], importTaskMovil [" + importTaskMovil + "], importTaskAmdocs [" + importTaskAmdocs + "]"));
        this.scope = scope;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.environment = new RestConnectorEnvironment(baseUrl, null, null, null, null);
        this.restConnector = new RestConnector(this.environment, (RestSecurityManager)this);
    }

    public InvoiceListItem[] getInvoices(String cuit, TasaConst.LineOfBusiness lineOfBusiness, Date fromDueDate, Date toDueDate) throws RestConnectorException {
        QueryBuilder queryBuilder = QueryBuilder.Builder().path("/billingmanagement/eerr/v1/invoices").add("tipoDocumento", "CUIT").add("numeroDocumento", cuit).add("invoiceStatus", "O").add("lineOfBusiness", lineOfBusiness.name());
        if (fromDueDate != null) {
            queryBuilder.add("fromDueDate", sdfTasa.format(fromDueDate));
        }
        if (toDueDate != null) {
            queryBuilder.add("toDueDate", sdfTasa.format(toDueDate));
        }
        String path = queryBuilder.build();
        log.debug((Object)("[getInvoices] Request GET invoices con cuit [" + cuit + "], lineOfBusiness [" + lineOfBusiness + "], fromDueDate [" + fromDueDate + "], toDueDate [" + toDueDate + "], path [" + path + "]"));
        Object[] response = (InvoiceListItem[])this.restConnector.genericGet(null, InvoiceListItem[].class, path);
        log.debug((Object)("[getInvoices] Response GET invoices [" + Arrays.toString(response) + "]"));
        return response;
    }

    public PaymentResponse postPayment(PaymentRequest paymentRequest) throws RestConnectorException {
        log.debug((Object)("[postPayment] Request POST payments con paymentRequest [" + paymentRequest + "]"));
        PaymentResponse response = (PaymentResponse)this.restConnector.genericPost((Object)paymentRequest, PaymentResponse.class, "/paymentmanagement/v1/payment");
        log.debug((Object)("[postPayment] Response POST payments [" + response + "]"));
        return response;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        TokenOAuth2 token = this.getToken();
        log.trace((Object)("[addHeaders] Token recuperado [" + token + "]"));
        builder.header("authorization", (Object)("Bearer " + token.getAccessToken()));
        builder.header("x-ibm-client-id", (Object)this.clientId);
        return builder;
    }

    private TokenOAuth2 getToken() throws RestConnectorException {
        Form form = new Form();
        form.param("client_id", this.clientId);
        form.param("client_secret", this.clientSecret);
        form.param("grant_type", "client_credentials");
        form.param("scope", this.scope);
        log.debug((Object)("[getToken] Por recuperar token con clientId [" + this.clientId + "], clientSecret [" + this.clientSecret + "], scope [" + this.scope + "]"));
        RestConnector tokenConnector = new RestConnector(this.environment, null);
        TokenOAuth2 tokenOAuth2Response = (TokenOAuth2)tokenConnector.genericPost((Object)form, TokenOAuth2.class, "/v1/oauth2/token", "application/json", "application/x-www-form-urlencoded");
        log.debug((Object)("[getToken] Token recuperado [" + tokenOAuth2Response + "]"));
        return tokenOAuth2Response;
    }
}

