package ar.com.sdd.tasa.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.math.BigDecimal;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class InvoiceListItem {

    private String ani;
    private LineOfBusiness lineOfBusiness;
    private Long invoiceId;
    private String accountId;
    private BigDecimal taxAmount;
    private BigDecimal amount;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMdd", timezone = "GMT-03:00")
    private Date dueDate;
    private String invoiceStatus;
    private Long billingArrangementId;
    private String billingInvoiceNumber;
    private Moneda currency;
    private InvoiceType invoiceType;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyyMMdd", timezone = "GMT-03:00")
    private Date issueDate;
    private String cae;

    public enum LineOfBusiness {
        WLN,    //Fijo
        WLS     //Movil
    }

    public enum InvoiceType {
        BILL,   //Bill Receiver
        CN,     //Credit Note
        DN,     //Debit Note
        RCG,    //Recharge
        EQP,    //Equipment purchase
    }

    enum Moneda {
        ARG,
        USD
    }

    @JsonProperty("ANI")
    public String getAni() {
        return ani;
    }

    public void setAni(String ani) {
        this.ani = ani;
    }

    public LineOfBusiness getLineOfBusiness() {
        return lineOfBusiness;
    }

    public void setLineOfBusiness(LineOfBusiness lineOfBusiness) {
        this.lineOfBusiness = lineOfBusiness;
    }

    public Long getInvoiceId() {
        return invoiceId;
    }

    public void setInvoiceId(Long invoiceId) {
        this.invoiceId = invoiceId;
    }

    public String getAccountId() {
        return accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getInvoiceStatus() {
        return invoiceStatus;
    }

    public void setInvoiceStatus(String invoiceStatus) {
        this.invoiceStatus = invoiceStatus;
    }

    public Long getBillingArrangementId() {
        return billingArrangementId;
    }

    public void setBillingArrangementId(Long billingArrangementId) {
        this.billingArrangementId = billingArrangementId;
    }

    public String getBillingInvoiceNumber() {
        return billingInvoiceNumber;
    }

    public void setBillingInvoiceNumber(String billingInvoiceNumber) {
        this.billingInvoiceNumber = billingInvoiceNumber;
    }

    public Moneda getCurrency() {
        return currency;
    }

    public void setCurrency(Moneda currency) {
        this.currency = currency;
    }

    public InvoiceType getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(InvoiceType invoiceType) {
        this.invoiceType = invoiceType;
    }

    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public String getCae() {
        return cae;
    }

    public void setCae(String cae) {
        this.cae = cae;
    }

    @Override
    public String toString() {
        return "InvoiceListItem ["
                + ((ani != null) ? "ani=" + ani + ", " : "")
                + ((lineOfBusiness != null) ? "lineOfBusiness=" + lineOfBusiness + ", " : "")
                + ((invoiceId != null) ? "invoiceId=" + invoiceId + ", " : "")
                + ((accountId != null) ? "accountId=" + accountId + ", " : "")
                + ((taxAmount != null) ? "taxAmount=" + taxAmount + ", " : "")
                + ((amount != null) ? "amount=" + amount + ", " : "")
                + ((dueDate != null) ? "dueDate=" + dueDate + ", " : "")
                + ((invoiceStatus != null) ? "invoiceStatus=" + invoiceStatus + ", " : "")
                + ((billingArrangementId != null) ? "billingArrangementId=" + billingArrangementId + ", " : "")
                + ((billingInvoiceNumber != null) ? "billingInvoiceNumber=" + billingInvoiceNumber + ", " : "")
                + ((currency != null) ? "currency=" + currency + ", " : "")
                + ((invoiceType != null) ? "invoiceType=" + invoiceType + ", " : "")
                + ((issueDate != null) ? "issueDate=" + issueDate + ", " : "")
                + ((cae != null) ? "cae=" + cae : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        InvoiceListItem that = (InvoiceListItem) o;

        if (ani != null ? !ani.equals(that.ani) : that.ani != null) return false;
        if (lineOfBusiness != that.lineOfBusiness) return false;
        if (invoiceId != null ? !invoiceId.equals(that.invoiceId) : that.invoiceId != null) return false;
        if (accountId != null ? !accountId.equals(that.accountId) : that.accountId != null) return false;
        if (taxAmount != null ? !taxAmount.equals(that.taxAmount) : that.taxAmount != null) return false;
        if (amount != null ? !amount.equals(that.amount) : that.amount != null) return false;
        if (dueDate != null ? !dueDate.equals(that.dueDate) : that.dueDate != null) return false;
        if (invoiceStatus != null ? !invoiceStatus.equals(that.invoiceStatus) : that.invoiceStatus != null)
            return false;
        if (billingArrangementId != null ? !billingArrangementId.equals(that.billingArrangementId) : that.billingArrangementId != null)
            return false;
        if (billingInvoiceNumber != null ? !billingInvoiceNumber.equals(that.billingInvoiceNumber) : that.billingInvoiceNumber != null)
            return false;
        if (currency != that.currency) return false;
        if (invoiceType != that.invoiceType) return false;
        if (issueDate != null ? !issueDate.equals(that.issueDate) : that.issueDate != null) return false;
        return cae != null ? cae.equals(that.cae) : that.cae == null;
    }

    @Override
    public int hashCode() {
        int result = ani != null ? ani.hashCode() : 0;
        result = 31 * result + (lineOfBusiness != null ? lineOfBusiness.hashCode() : 0);
        result = 31 * result + (invoiceId != null ? invoiceId.hashCode() : 0);
        result = 31 * result + (accountId != null ? accountId.hashCode() : 0);
        result = 31 * result + (taxAmount != null ? taxAmount.hashCode() : 0);
        result = 31 * result + (amount != null ? amount.hashCode() : 0);
        result = 31 * result + (dueDate != null ? dueDate.hashCode() : 0);
        result = 31 * result + (invoiceStatus != null ? invoiceStatus.hashCode() : 0);
        result = 31 * result + (billingArrangementId != null ? billingArrangementId.hashCode() : 0);
        result = 31 * result + (billingInvoiceNumber != null ? billingInvoiceNumber.hashCode() : 0);
        result = 31 * result + (currency != null ? currency.hashCode() : 0);
        result = 31 * result + (invoiceType != null ? invoiceType.hashCode() : 0);
        result = 31 * result + (issueDate != null ? issueDate.hashCode() : 0);
        result = 31 * result + (cae != null ? cae.hashCode() : 0);
        return result;
    }


}

