package ar.com.sdd.teco.shiva.model

import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class DatosGestionCobranza {

    var acuerdoFacturacion: String? = null
    var saldoPesificadoFechaCotizacion: String? = null
    var tipoCambioFechaCotizacion: String? = null
    var importePagoMinimo: String? = null

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd/MM/yyyy")
    var fechaVencimientoMora: String? = null

    var saldoPesificado: String? = null

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd/MM/yyyy")
    var fechaVencimiento: String? = null
    var estadoAcuerdoFacturacionCalipso: String? = null
    var estadoAcuerdoFacturacionMic: String? = null

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd/MM/yyyy")
    var fechaEmision: String? = null
    var tipoCambio: String? = null
    var estadoContrato: String? = null

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd/MM/yyyy")
    var fechaTipoCambio: String? = null
    var destransferirTerceros: String? = null

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd/MM/yyyy")
    var fechaPuestaCobro: String? = null

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd/MM/yyyy")
    var fechaUltimoPagoParcial: String? = null
    var importeTercerosTransferidos: String? = null
    var saldoTerceroFinanciableTransferible: String? = null
    var moneda: String? = null
    var importeAPrimerVencimiento: String? = null
    var importeASegundoVencimiento: String? = null
    var saldoPrimerVencimientoMonedaOrigen: String? = null
    var importePrimerVencimientoPesificado: String? = null
    var importePrimerVencimientoTerceros: String? = null
    var importeSegundoVencimientoTerceros: String? = null
    var estadoConceptosDeTerceros: String? = null
    var importePrimerVencimientoPesificadoAFechaCotizacion: String? = null
    var saldoTerceroFinanciableNoTransferible: String? = null
    var saldoTerceroNoFinanciableTransferible: String? = null
    var sinDiferenciaDeCambio: String? = null
    var cobrarAlSegundoVencimiento: String? = null

    override fun toString(): String {
        return "DatosGestionCobranza(acuerdoFacturacion=$acuerdoFacturacion, saldoPesificadoFechaCotizacion=$saldoPesificadoFechaCotizacion, tipoCambioFechaCotizacion=$tipoCambioFechaCotizacion, importePagoMinimo=$importePagoMinimo, fechaVencimientoMora=$fechaVencimientoMora, saldoPesificado=$saldoPesificado, fechaVencimiento=$fechaVencimiento, estadoAcuerdoFacturacionCalipso=$estadoAcuerdoFacturacionCalipso, estadoAcuerdoFacturacionMic=$estadoAcuerdoFacturacionMic, fechaEmision=$fechaEmision, tipoCambio=$tipoCambio, estadoContrato=$estadoContrato, fechaTipoCambio=$fechaTipoCambio, destransferirTerceros=$destransferirTerceros, fechaPuestaCobro=$fechaPuestaCobro, fechaUltimoPagoParcial=$fechaUltimoPagoParcial, importeTercerosTransferidos=$importeTercerosTransferidos, saldoTerceroFinanciableTransferible=$saldoTerceroFinanciableTransferible, moneda=$moneda, importeAPrimerVencimiento=$importeAPrimerVencimiento, importeASegundoVencimiento=$importeASegundoVencimiento, saldoPrimerVencimientoMonedaOrigen=$saldoPrimerVencimientoMonedaOrigen, importePrimerVencimientoPesificado=$importePrimerVencimientoPesificado, importePrimerVencimientoTerceros=$importePrimerVencimientoTerceros, importeSegundoVencimientoTerceros=$importeSegundoVencimientoTerceros, estadoConceptosDeTerceros=$estadoConceptosDeTerceros, importePrimerVencimientoPesificadoAFechaCotizacion=$importePrimerVencimientoPesificadoAFechaCotizacion, saldoTerceroFinanciableNoTransferible=$saldoTerceroFinanciableNoTransferible, saldoTerceroNoFinanciableTransferible=$saldoTerceroNoFinanciableTransferible, sinDiferenciaDeCambio=$sinDiferenciaDeCambio, cobrarAlSegundoVencimiento=$cobrarAlSegundoVencimiento)"
    }
}