package ar.com.sdd.teco.shiva.core

import ar.com.sdd.commons.rest.core.RestConnector
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment
import ar.com.sdd.commons.rest.core.RestSecurityManager
import ar.com.sdd.commons.rest.model.TokenOAuth2
import ar.com.sdd.commons.rest.util.QueryBuilder
import ar.com.sdd.commons.rest.util.RestConnectorUtil
import ar.com.sdd.teco.shiva.io.ConsultaClienteTecoShivaResponse
import ar.com.sdd.teco.shiva.io.ConsultaDeudaTecoShivaRequest
import ar.com.sdd.teco.shiva.io.ConsultaDeudaTecoShivaResponse
import ar.com.sdd.teco.shiva.io.TecoShivaErrorResponse
import org.apache.log4j.Logger
import javax.ws.rs.client.Invocation
import javax.ws.rs.core.Form
import javax.ws.rs.core.MediaType

open class TecoShivaConnector(context: TecoShivaConnectorContext) : RestSecurityManager {

    private val log: Logger = Logger.getLogger(TecoShivaConnector::class.java)

    private val restConnector: RestConnector
    private val context: TecoShivaConnectorContext

    init {
        log.debug("Creando TecoShivaConnector para authUrl [${context.getAuthUrl()}], endpoint [${context.getEndpointUrl()}], user [${context.getUser()}], pass [${context.getPass()}]")
        this.context = context
        val environment = RestConnectorEnvironment(context.getEndpointUrl())
        restConnector = RestConnector(environment, this)
    }

    override fun addHeaders(builder: Invocation.Builder?): Invocation.Builder? {
        //Recupero el token
        log.debug("Recuperando Token")
        val form = Form()
        form.param("grant_type", "client_credentials")

        val environment = RestConnectorEnvironment()
        environment.baseUrl = context.getAuthUrl()
        val connector = RestConnector(environment, RestSecurityManager { b ->
            b?.header("Authorization", RestConnectorUtil.getBasicAuthHeader(context.getUser(), context.getPass()))
        })
        val tokenOAuth2Response = connector.genericPost(form, TokenOAuth2::class.java, "", MediaType.APPLICATION_JSON, MediaType.APPLICATION_FORM_URLENCODED)
        log.debug("Token recuperado [$tokenOAuth2Response]")
        val token = tokenOAuth2Response.accessToken

        builder?.header("Authorization", "Bearer $token")

        return builder
    }


    fun consultaCliente(tipoDocumento: String, numeroDocumento: String): ConsultaClienteTecoShivaResponse {
        val queryBuilder: QueryBuilder = QueryBuilder.Builder().path("/cliente")
                .add("tipoDocumento", tipoDocumento)
                .add("numeroDocumento", numeroDocumento)

        val path = queryBuilder.build()
        log.debug("[consultaClientes] Request GET cliente con tipoDocumento [$tipoDocumento], numeroDocumento [$numeroDocumento], path [$path]")
        val response = restConnector.genericGet(null, ConsultaClienteTecoShivaResponse::class.java, TecoShivaErrorResponse::class.java, path)
        log.debug("[consultaClientes] Response GET cliente [$response]")

        return response
    }


    fun consultaDeuda(request: ConsultaDeudaTecoShivaRequest): ConsultaDeudaTecoShivaResponse {
        val path = "/deuda"
        log.debug("[consultaDeuda] Request POST deuda con request [$request], path [$path]")
        val response = restConnector.genericPost(request, ConsultaDeudaTecoShivaResponse::class.java, TecoShivaErrorResponse::class.java, path)
        log.debug("[consultaDeuda] Response POST deuda [$response]")

        return response
    }

}