package ar.com.sdd.teco.shiva.model

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class Cliente {

    var empresasAsociadas: String? = null
    var sistemas: List<String>? = null
    var codigoPostal: String? = null
    var clienteOrigen: String? = null
    var codigoHolding: String? = null
    var agenciaNegocio: String? = null
    var segmentoAgencia: String? = null
    var idClienteLegado: String? = null
    var tipoDocumento: String? = null
    var razonSocial: String? = null
    var descripcionHolding: String? = null
    var descripcionAgenciaNegocio: String? = null
    var idProvincia: String? = null
    var origen: String? = null
    var addressId: String? = null
    var numeroDocumento: String? = null
    var idClientePerfil: String? = null

    override fun toString(): String {
        return "Cliente(empresasAsociadas=$empresasAsociadas, sistemas=$sistemas, codigoPostal=$codigoPostal, clienteOrigen=$clienteOrigen, codigoHolding=$codigoHolding, agenciaNegocio=$agenciaNegocio, segmentoAgencia=$segmentoAgencia, idClienteLegado=$idClienteLegado, tipoDocumento=$tipoDocumento, razonSocial=$razonSocial, descripcionHolding=$descripcionHolding, descripcionAgenciaNegocio=$descripcionAgenciaNegocio, idProvincia=$idProvincia, origen=$origen, addressId=$addressId, numeroDocumento=$numeroDocumento, idClientePerfil=$idClientePerfil)"
    }
}