package ar.com.sdd.teco.shiva.model

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class ContratoResultado {

    var contrato: String? = null
    var saldo: String? = null
    var monedaImporteACobrar: String? = null
    var marcaTasaCero: String? = null
    var cantidadDeDias: String? = null
    var marcaDA: String? = null
    var descripcionDA: String? = null
    var operacionAsociada: String? = null
    var numeroReferencia: String? = null
    var marcaReclamo: String? = null
    var estadoOrigen: String? = null
    var cliente: String? = null
    var analista: String? = null
    var fechaValor: String? = null
    var claseComprobante: String? = null
    var tipoComprobante: String? = null
    var sucursalComprobante: String? = null
    var idDocumentoCuentaCobranza: String? = null
    var tipoDocumento: String? = null
    var sistema: String? = null
    var numeroComprobante: String? = null
    var origen: String? = null
    var estadoContrato: String? = null
    var marcaPagoCompensacionEnProcesoShiva: String? = null
    var marcaReversionDeCobroProcesoPendiente: String? = null
    var marcaReversionDeCobroEdicion: String? = null
    var moneda: String? = null
    var sistemaOrigen: String? = null
    var sociedad: String? = null
    var estadoOrigenCodigo: String? = null
    var operacionesAsociadasAnalista: String? = null
    var semaforoGestionabilidad: SemaforoGestionabilidad? = null

    override fun toString(): String {
        return "ContratoResultado(contrato=$contrato, saldo=$saldo, monedaImporteACobrar=$monedaImporteACobrar, marcaTasaCero=$marcaTasaCero, cantidadDeDias=$cantidadDeDias, marcaDA=$marcaDA, descripcionDA=$descripcionDA, operacionAsociada=$operacionAsociada, numeroReferencia=$numeroReferencia, marcaReclamo=$marcaReclamo, estadoOrigen=$estadoOrigen, cliente=$cliente, analista=$analista, fechaValor=$fechaValor, claseComprobante=$claseComprobante, tipoComprobante=$tipoComprobante, sucursalComprobante=$sucursalComprobante, idDocumentoCuentaCobranza=$idDocumentoCuentaCobranza, tipoDocumento=$tipoDocumento, sistema=$sistema, numeroComprobante=$numeroComprobante, origen=$origen, estadoContrato=$estadoContrato, marcaPagoCompensacionEnProcesoShiva=$marcaPagoCompensacionEnProcesoShiva, marcaReversionDeCobroProcesoPendiente=$marcaReversionDeCobroProcesoPendiente, marcaReversionDeCobroEdicion=$marcaReversionDeCobroEdicion, moneda=$moneda, sistemaOrigen=$sistemaOrigen, sociedad=$sociedad, estadoOrigenCodigo=$estadoOrigenCodigo, operacionesAsociadasAnalista=$operacionesAsociadasAnalista, semaforoGestionabilidad=$semaforoGestionabilidad)"
    }

}