package ar.com.sdd.teco.shiva.model

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class DatosClaveDebito {

    var numeroReferenciaDuc: String? = null
    var numeroReferencia: String? = null
    var cuenta: String? = null
    var cliente: String? = null
    var claseComprobante: String? = null
    var sucursalComprobante: String? = null
    var idDocumentoCuentaCobranza: String? = null
    var tipoDocumento: String? = null
    var numeroComprobante: String? = null
    var numeroDocumento: String? = null
    var idContrato: String? = null
    var tipoFactura: String? = null
    var tipoComprobanteCodigo: String? = null
    var tipoComprobanteDescripcion: String? = null
    var numeroDocumentoLegalFormateado: String? = null

    override fun toString(): String {
        return "DatosClaveDebito(numeroReferenciaDuc=$numeroReferenciaDuc, numeroReferencia=$numeroReferencia, cuenta=$cuenta, cliente=$cliente, claseComprobante=$claseComprobante, sucursalComprobante=$sucursalComprobante, idDocumentoCuentaCobranza=$idDocumentoCuentaCobranza, tipoDocumento=$tipoDocumento, numeroComprobante=$numeroComprobante, numeroDocumento=$numeroDocumento, idContrato=$idContrato, tipoFactura=$tipoFactura, tipoComprobanteCodigo=$tipoComprobanteCodigo, tipoComprobanteDescripcion=$tipoComprobanteDescripcion, numeroDocumentoLegalFormateado=$numeroDocumentoLegalFormateado)"
    }

}