package ar.com.sdd.teco.shiva.model

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonProperty

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class InicioPorSistema {
    @JsonProperty("OPEN")
    var open: String? = null

    @JsonProperty("MIC")
    var mic: String? = null

    @JsonProperty("NEGOCIO_NET")
    var negocioNet: String? = null

    @JsonProperty("CALIPSO")
    var calipso: String? = null

    override fun toString(): String {
        return "InicioPorSistema(open=$open, mic=$mic, negocioNet=$negocioNet, calipso=$calipso)"
    }

}