package ar.com.sdd.teco.shiva.model


import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonProperty

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class TotalesPorSistema {
    @JsonProperty("OPEN")
    var open: Long? = null

    @JsonProperty("MIC")
    var mic: Long? = null

    @JsonProperty("NEGOCIO_NET")
    var negocioNet: Long? = null

    @JsonProperty("CALIPSO")
    var calipso: Long? = null

    override fun toString(): String {
        return "TotalesPorSistema(open=$open, mic=$mic, negocioNet=$negocioNet, calipso=$calipso)"
    }

}