package ar.com.sdd.teco.shiva.util

import com.fasterxml.jackson.core.JsonParser
import com.fasterxml.jackson.databind.DeserializationContext
import com.fasterxml.jackson.databind.deser.std.StdDeserializer
import java.text.SimpleDateFormat
import java.util.*

/**
 * Convierte el formato de Teco de importes
 * Si viene, null, vacio o "-", devuelve null
 * Convierte la fecha de formato dd/MM/yyyy
 *
 */
open class TecoDateDeserializer : StdDeserializer<Date?>(Date::class.java) {

    override fun deserialize(jsonParser: JsonParser?, deserializationContext: DeserializationContext?): Date? {
        if (jsonParser != null) {
            val dateFormat = SimpleDateFormat("dd/MM/yyyy")
            val dateString = jsonParser.readValueAs(String::class.java)
            if (dateString == null || dateString.trim() == "" || dateString.trim() == "-") {
                return null
            } else {
                return dateFormat.parse(dateString)
            }

        } else {
            throw Exception("jsonParser es null")
        }
    }

}