package ar.com.sdd.teco.shiva.model

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class DatosResultado {

    var datosGestionCobranza: DatosGestionCobranza? = null
    var datosGestionAdminisrativa: DatosGestionAdminisrativa? = null
    var datosClaveDebito: DatosClaveDebito? = null
    var datosGestionShiva: DatosGestionShiva? = null
    var datosGestionDeimos: DatosGestionDeimos? = null
    var datosOrigenDocumento: DatosOrigenDocumento? = null
    var semaforoGestionabilidad: SemaforoGestionabilidad? = null

    override fun toString(): String {
        return "DatosResultado(datosGestionCobranza=$datosGestionCobranza, datosGestionAdminisrativa=$datosGestionAdminisrativa, datosClaveDebito=$datosClaveDebito, datosGestionShiva=$datosGestionShiva, datosGestionDeimos=$datosGestionDeimos, datosOrigenDocumento=$datosOrigenDocumento, semaforoGestionabilidad=$semaforoGestionabilidad)"
    }

}