package ar.com.sdd.teco.shiva.model

import ar.com.sdd.teco.shiva.util.TecoStringDeserializer
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.databind.annotation.JsonDeserialize

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class SemaforoGestionabilidad {

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var descripcionError: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var codigoError: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var color: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var observacion: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var cobrarDeuda: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var gestionable: String? = null

    override fun toString(): String {
        return "SemaforoGestionabilidad(descripcionError=$descripcionError, codigoError=$codigoError, color=$color, observacion=$observacion, cobrarDeuda=$cobrarDeuda, gestionable=$gestionable)"
    }

}