package ar.com.sdd.teco.shiva.util

import com.fasterxml.jackson.core.JsonParser
import com.fasterxml.jackson.databind.DeserializationContext
import com.fasterxml.jackson.databind.deser.std.StdDeserializer

/**
 * Convierte el formato de Teco de Strings
 * Si viene, null, vacio o "-", devuelve null
 *
 */
open class TecoStringDeserializer : StdDeserializer<String?>(String::class.java) {

    override fun deserialize(jsonParser: JsonParser?, deserializationContext: DeserializationContext?): String? {
        if (jsonParser != null) {
            val string = jsonParser.readValueAs(String::class.java)
            return if (string == null || string.trim() == "" || string.trim() == "-") {
                null
            } else {
                string
            }

        } else {
            throw Exception("jsonParser es null")
        }
    }
}